/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util;

import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.InvalidCipherTextException;
import com.timevale.tgtext.bouncycastle.crypto.Wrapper;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithIV;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.PBE;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class BaseWrapCipher
extends CipherSpi
implements PBE {
    private Class[] availableSpecs = new Class[]{IvParameterSpec.class, PBEParameterSpec.class, RC2ParameterSpec.class, RC5ParameterSpec.class};
    protected int pbeType = 2;
    protected int pbeHash = 1;
    protected int pbeKeySize;
    protected int pbeIvSize;
    protected AlgorithmParameters engineParams = null;
    protected Wrapper wrapEngine = null;
    private int ivSize;
    private byte[] iv;

    protected BaseWrapCipher() {
    }

    protected BaseWrapCipher(Wrapper wrapEngine) {
        this(wrapEngine, 0);
    }

    protected BaseWrapCipher(Wrapper wrapEngine, int ivSize) {
        this.wrapEngine = wrapEngine;
        this.ivSize = ivSize;
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected byte[] engineGetIV() {
        return (byte[])this.iv.clone();
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return -1;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("can't support mode " + mode);
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("Padding " + padding + " unknown.");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        void var5_11;
        if (key instanceof BCPBEKey) {
            BCPBEKey k2 = (BCPBEKey)key;
            if (params instanceof PBEParameterSpec) {
                CipherParameters cipherParameters = PBE.Util.makePBEParameters(k2, params, this.wrapEngine.getAlgorithmName());
            } else {
                if (k2.getParam() == null) throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
                CipherParameters cipherParameters = k2.getParam();
            }
        } else {
            KeyParameter keyParameter = new KeyParameter(key.getEncoded());
        }
        if (params instanceof IvParameterSpec) {
            void var5_9;
            IvParameterSpec iv = (IvParameterSpec)params;
            ParametersWithIV parametersWithIV = new ParametersWithIV((CipherParameters)var5_9, iv.getIV());
        }
        if (var5_11 instanceof KeyParameter && this.ivSize != 0) {
            this.iv = new byte[this.ivSize];
            random.nextBytes(this.iv);
            ParametersWithIV parametersWithIV = new ParametersWithIV((CipherParameters)var5_11, this.iv);
        }
        switch (opmode) {
            case 3: {
                void var5_13;
                this.wrapEngine.init(true, (CipherParameters)var5_13);
                return;
            }
            case 4: {
                void var5_13;
                this.wrapEngine.init(false, (CipherParameters)var5_13);
                return;
            }
            case 1: 
            case 2: {
                throw new IllegalArgumentException("engine only valid for wrapping");
            }
        }
        System.out.println("eeek!");
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec paramSpec = null;
        if (params != null) {
            for (int i2 = 0; i2 != this.availableSpecs.length; ++i2) {
                try {
                    paramSpec = (AlgorithmParameterSpec)params.getParameterSpec(this.availableSpecs[i2]);
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (paramSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + params.toString());
            }
        }
        this.engineParams = params;
        this.engineInit(opmode, key, paramSpec, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
            return;
        }
        catch (InvalidAlgorithmParameterException e2) {
            throw new IllegalArgumentException(e2.getMessage());
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        throw new RuntimeException("not supported for wrapping");
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        throw new RuntimeException("not supported for wrapping");
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        return null;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        return 0;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] encoded = key.getEncoded();
        if (encoded == null) {
            throw new InvalidKeyException("Cannot wrap key, null encoding.");
        }
        try {
            if (this.wrapEngine == null) {
                return this.engineDoFinal(encoded, 0, encoded.length);
            }
            return this.wrapEngine.wrap(encoded, 0, encoded.length);
        }
        catch (BadPaddingException e2) {
            throw new IllegalBlockSizeException(e2.getMessage());
        }
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] encoded;
        try {
            encoded = this.wrapEngine == null ? this.engineDoFinal(wrappedKey, 0, wrappedKey.length) : this.wrapEngine.unwrap(wrappedKey, 0, wrappedKey.length);
        }
        catch (InvalidCipherTextException e2) {
            throw new InvalidKeyException(e2.getMessage());
        }
        catch (BadPaddingException e3) {
            throw new InvalidKeyException(e3.getMessage());
        }
        catch (IllegalBlockSizeException e2) {
            throw new InvalidKeyException(e2.getMessage());
        }
        if (wrappedKeyType == 3) {
            return new SecretKeySpec(encoded, wrappedKeyAlgorithm);
        }
        if (wrappedKeyAlgorithm.equals("") && wrappedKeyType == 2) {
            try {
                PrivateKeyInfo in = PrivateKeyInfo.getInstance(encoded);
                PrivateKey privKey = BouncyCastleProvider.getPrivateKey(in);
                if (privKey != null) {
                    return privKey;
                }
                throw new InvalidKeyException("algorithm " + in.getPrivateKeyAlgorithm().getAlgorithm() + " not supported");
            }
            catch (Exception exception) {
                throw new InvalidKeyException("Invalid key encoding.");
            }
        }
        try {
            KeyFactory kf = KeyFactory.getInstance(wrappedKeyAlgorithm, BouncyCastleProvider.PROVIDER_NAME);
            if (wrappedKeyType == 1) {
                return kf.generatePublic(new X509EncodedKeySpec(encoded));
            }
            if (wrappedKeyType == 2) {
                return kf.generatePrivate(new PKCS8EncodedKeySpec(encoded));
            }
        }
        catch (NoSuchProviderException e4) {
            throw new InvalidKeyException("Unknown key type " + e4.getMessage());
        }
        catch (InvalidKeySpecException e2) {
            throw new InvalidKeyException("Unknown key type " + e2.getMessage());
        }
        throw new InvalidKeyException("Unknown key type " + wrappedKeyType);
    }
}

