/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.rsa;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateKey;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.rsa.RSAUtil;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.util.ExtendedInvalidKeySpecException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class KeyFactorySpi
extends BaseKeyFactorySpi {
    @Override
    protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
        if (spec.isAssignableFrom(RSAPublicKeySpec.class) && key instanceof RSAPublicKey) {
            RSAPublicKey k2 = (RSAPublicKey)key;
            return new RSAPublicKeySpec(k2.getModulus(), k2.getPublicExponent());
        }
        if (spec.isAssignableFrom(RSAPrivateKeySpec.class) && key instanceof RSAPrivateKey) {
            RSAPrivateKey k3 = (RSAPrivateKey)key;
            return new RSAPrivateKeySpec(k3.getModulus(), k3.getPrivateExponent());
        }
        if (spec.isAssignableFrom(RSAPrivateCrtKeySpec.class) && key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey k4 = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeySpec(k4.getModulus(), k4.getPublicExponent(), k4.getPrivateExponent(), k4.getPrimeP(), k4.getPrimeQ(), k4.getPrimeExponentP(), k4.getPrimeExponentQ(), k4.getCrtCoefficient());
        }
        return super.engineGetKeySpec(key, spec);
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof RSAPublicKey) {
            return new BCRSAPublicKey((RSAPublicKey)key);
        }
        if (key instanceof RSAPrivateCrtKey) {
            return new BCRSAPrivateCrtKey((RSAPrivateCrtKey)key);
        }
        if (key instanceof RSAPrivateKey) {
            return new BCRSAPrivateKey((RSAPrivateKey)key);
        }
        throw new InvalidKeyException("key type unknown");
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                return this.generatePrivate(PrivateKeyInfo.getInstance(((PKCS8EncodedKeySpec)keySpec).getEncoded()));
            }
            catch (Exception e2) {
                try {
                    return new BCRSAPrivateCrtKey(com.timevale.tgtext.bouncycastle.asn1.pkcs.RSAPrivateKey.getInstance(((PKCS8EncodedKeySpec)keySpec).getEncoded()));
                }
                catch (Exception exception) {
                    throw new ExtendedInvalidKeySpecException("unable to process key spec: " + e2.toString(), e2);
                }
            }
        }
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            return new BCRSAPrivateCrtKey((RSAPrivateCrtKeySpec)keySpec);
        }
        if (keySpec instanceof RSAPrivateKeySpec) {
            return new BCRSAPrivateKey((RSAPrivateKeySpec)keySpec);
        }
        throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPublicKeySpec) {
            return new BCRSAPublicKey((RSAPublicKeySpec)keySpec);
        }
        return super.engineGeneratePublic(keySpec);
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier algOid = keyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (RSAUtil.isRsaOid(algOid)) {
            return new BCRSAPrivateCrtKey(keyInfo);
        }
        throw new IOException("algorithm identifier " + algOid + " in key not recognised");
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier algOid = keyInfo.getAlgorithm().getAlgorithm();
        if (RSAUtil.isRsaOid(algOid)) {
            return new BCRSAPublicKey(keyInfo);
        }
        throw new IOException("algorithm identifier " + algOid + " in key not recognised");
    }
}

