/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.cmp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.cmp.CMPCertificate;
import com.timevale.tgtext.bouncycastle.asn1.cmp.CertResponse;

public class CertRepMessage
extends ASN1Object {
    private ASN1Sequence caPubs;
    private ASN1Sequence response;

    private CertRepMessage(ASN1Sequence seq) {
        int index = 0;
        if (seq.size() > 1) {
            ++index;
            this.caPubs = ASN1Sequence.getInstance((ASN1TaggedObject)seq.getObjectAt(0), true);
        }
        this.response = ASN1Sequence.getInstance(seq.getObjectAt(index));
    }

    public static CertRepMessage getInstance(Object o2) {
        if (o2 instanceof CertRepMessage) {
            return (CertRepMessage)o2;
        }
        if (o2 != null) {
            return new CertRepMessage(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public CertRepMessage(CMPCertificate[] caPubs, CertResponse[] response) {
        int i2;
        ASN1EncodableVector v2;
        if (response == null) {
            throw new IllegalArgumentException("'response' cannot be null");
        }
        if (caPubs != null) {
            v2 = new ASN1EncodableVector();
            for (i2 = 0; i2 < caPubs.length; ++i2) {
                v2.add(caPubs[i2]);
            }
            this.caPubs = new DERSequence(v2);
        }
        v2 = new ASN1EncodableVector();
        for (i2 = 0; i2 < response.length; ++i2) {
            v2.add(response[i2]);
        }
        this.response = new DERSequence(v2);
    }

    public CMPCertificate[] getCaPubs() {
        if (this.caPubs == null) {
            return null;
        }
        CMPCertificate[] results = new CMPCertificate[this.caPubs.size()];
        for (int i2 = 0; i2 != results.length; ++i2) {
            results[i2] = CMPCertificate.getInstance(this.caPubs.getObjectAt(i2));
        }
        return results;
    }

    public CertResponse[] getResponse() {
        CertResponse[] results = new CertResponse[this.response.size()];
        for (int i2 = 0; i2 != results.length; ++i2) {
            results[i2] = CertResponse.getInstance(this.response.getObjectAt(i2));
        }
        return results;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        if (this.caPubs != null) {
            v2.add(new DERTaggedObject(true, 1, this.caPubs));
        }
        v2.add(this.response);
        return new DERSequence(v2);
    }
}

