/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.crmf;

import com.timevale.tgtext.bouncycastle.cert.crmf.EncryptedValuePadder;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA1Digest;
import com.timevale.tgtext.bouncycastle.crypto.generators.MGF1BytesGenerator;
import com.timevale.tgtext.bouncycastle.crypto.params.MGFParameters;
import java.security.SecureRandom;

public class FixedLengthMGF1Padder
implements EncryptedValuePadder {
    private int length;
    private SecureRandom random;
    private Digest dig = new SHA1Digest();

    public FixedLengthMGF1Padder(int length) {
        this(length, null);
    }

    public FixedLengthMGF1Padder(int length, SecureRandom random) {
        this.length = length;
        this.random = random;
    }

    @Override
    public byte[] getPaddedData(byte[] data) {
        int i2;
        byte[] bytes = new byte[this.length];
        byte[] seed = new byte[this.dig.getDigestSize()];
        byte[] mask = new byte[this.length - this.dig.getDigestSize()];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(seed);
        MGF1BytesGenerator maskGen = new MGF1BytesGenerator(this.dig);
        maskGen.init(new MGFParameters(seed));
        maskGen.generateBytes(mask, 0, mask.length);
        System.arraycopy(seed, 0, bytes, 0, seed.length);
        System.arraycopy(data, 0, bytes, seed.length, data.length);
        for (i2 = seed.length + data.length + 1; i2 != bytes.length; ++i2) {
            bytes[i2] = (byte)(1 + this.random.nextInt(255));
        }
        for (i2 = 0; i2 != mask.length; ++i2) {
            int n2 = i2 + seed.length;
            bytes[n2] = (byte)(bytes[n2] ^ mask[i2]);
        }
        return bytes;
    }

    @Override
    public byte[] getUnpaddedData(byte[] paddedData) {
        byte[] seed = new byte[this.dig.getDigestSize()];
        byte[] mask = new byte[this.length - this.dig.getDigestSize()];
        System.arraycopy(paddedData, 0, seed, 0, seed.length);
        MGF1BytesGenerator maskGen = new MGF1BytesGenerator(this.dig);
        maskGen.init(new MGFParameters(seed));
        maskGen.generateBytes(mask, 0, mask.length);
        for (int i2 = 0; i2 != mask.length; ++i2) {
            int n2 = i2 + seed.length;
            paddedData[n2] = (byte)(paddedData[n2] ^ mask[i2]);
        }
        int end = 0;
        for (int i3 = paddedData.length - 1; i3 != seed.length; --i3) {
            if (paddedData[i3] != 0) continue;
            end = i3;
            break;
        }
        if (end == 0) {
            throw new IllegalStateException("bad padding in encoding");
        }
        byte[] data = new byte[end - seed.length];
        System.arraycopy(paddedData, seed.length, data, 0, data.length);
        return data;
    }
}

