/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.rainbow;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.DERNull;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.pqc.asn1.RainbowPrivateKey;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.Layer;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.util.RainbowUtil;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.spec.RainbowPrivateKeySpec;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.Arrays;

public class BCRainbowPrivateKey
implements PrivateKey {
    private static final long serialVersionUID = 1L;
    private short[][] A1inv;
    private short[] b1;
    private short[][] A2inv;
    private short[] b2;
    private Layer[] layers;
    private int[] vi;

    public BCRainbowPrivateKey(short[][] A1inv, short[] b1, short[][] A2inv, short[] b2, int[] vi, Layer[] layers) {
        this.A1inv = A1inv;
        this.b1 = b1;
        this.A2inv = A2inv;
        this.b2 = b2;
        this.vi = vi;
        this.layers = layers;
    }

    public BCRainbowPrivateKey(RainbowPrivateKeySpec keySpec) {
        this(keySpec.getInvA1(), keySpec.getB1(), keySpec.getInvA2(), keySpec.getB2(), keySpec.getVi(), keySpec.getLayers());
    }

    public BCRainbowPrivateKey(RainbowPrivateKeyParameters params) {
        this(params.getInvA1(), params.getB1(), params.getInvA2(), params.getB2(), params.getVi(), params.getLayers());
    }

    public short[][] getInvA1() {
        return this.A1inv;
    }

    public short[] getB1() {
        return this.b1;
    }

    public short[] getB2() {
        return this.b2;
    }

    public short[][] getInvA2() {
        return this.A2inv;
    }

    public Layer[] getLayers() {
        return this.layers;
    }

    public int[] getVi() {
        return this.vi;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof BCRainbowPrivateKey)) {
            return false;
        }
        BCRainbowPrivateKey otherKey = (BCRainbowPrivateKey)other;
        boolean eq2 = RainbowUtil.equals(this.A1inv, otherKey.getInvA1());
        eq2 = eq2 && RainbowUtil.equals(this.A2inv, otherKey.getInvA2());
        eq2 = eq2 && RainbowUtil.equals(this.b1, otherKey.getB1());
        eq2 = eq2 && RainbowUtil.equals(this.b2, otherKey.getB2());
        boolean bl2 = eq2 = eq2 && Arrays.equals(this.vi, otherKey.getVi());
        if (this.layers.length != otherKey.getLayers().length) {
            return false;
        }
        for (int i2 = this.layers.length - 1; i2 >= 0; --i2) {
            eq2 &= this.layers[i2].equals(otherKey.getLayers()[i2]);
        }
        return eq2;
    }

    public int hashCode() {
        int hash = this.layers.length;
        hash = hash * 37 + com.timevale.tgtext.bouncycastle.util.Arrays.hashCode(this.A1inv);
        hash = hash * 37 + com.timevale.tgtext.bouncycastle.util.Arrays.hashCode(this.b1);
        hash = hash * 37 + com.timevale.tgtext.bouncycastle.util.Arrays.hashCode(this.A2inv);
        hash = hash * 37 + com.timevale.tgtext.bouncycastle.util.Arrays.hashCode(this.b2);
        hash = hash * 37 + com.timevale.tgtext.bouncycastle.util.Arrays.hashCode(this.vi);
        for (int i2 = this.layers.length - 1; i2 >= 0; --i2) {
            hash = hash * 37 + this.layers[i2].hashCode();
        }
        return hash;
    }

    @Override
    public final String getAlgorithm() {
        return "Rainbow";
    }

    @Override
    public byte[] getEncoded() {
        PrivateKeyInfo pki;
        RainbowPrivateKey privateKey = new RainbowPrivateKey(this.A1inv, this.b1, this.A2inv, this.b2, this.vi, this.layers);
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.rainbow, (ASN1Encodable)DERNull.INSTANCE);
            pki = new PrivateKeyInfo(algorithmIdentifier, privateKey);
        }
        catch (IOException iOException) {
            IOException e2 = iOException;
            iOException.printStackTrace();
            return null;
        }
        try {
            byte[] encoded = pki.getEncoded();
            return encoded;
        }
        catch (IOException iOException) {
            IOException e3 = iOException;
            iOException.printStackTrace();
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }
}

