/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.generators;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.Mac;
import com.timevale.tgtext.bouncycastle.crypto.PBEParametersGenerator;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA1Digest;
import com.timevale.tgtext.bouncycastle.crypto.macs.HMac;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithIV;

public class PKCS5S2ParametersGenerator
extends PBEParametersGenerator {
    private Mac hMac;

    public PKCS5S2ParametersGenerator() {
        this(new SHA1Digest());
    }

    public PKCS5S2ParametersGenerator(Digest digest) {
        this.hMac = new HMac(digest);
    }

    private void F(byte[] P, byte[] S, int c2, byte[] iBuf, byte[] out, int outOff) {
        byte[] state = new byte[this.hMac.getMacSize()];
        KeyParameter param = new KeyParameter(P);
        this.hMac.init(param);
        if (S != null) {
            this.hMac.update(S, 0, S.length);
        }
        this.hMac.update(iBuf, 0, iBuf.length);
        this.hMac.doFinal(state, 0);
        System.arraycopy(state, 0, out, outOff, state.length);
        if (c2 == 0) {
            throw new IllegalArgumentException("iteration count must be at least 1.");
        }
        for (int count = 1; count < c2; ++count) {
            this.hMac.init(param);
            this.hMac.update(state, 0, state.length);
            this.hMac.doFinal(state, 0);
            for (int j2 = 0; j2 != state.length; ++j2) {
                int n2 = outOff + j2;
                out[n2] = (byte)(out[n2] ^ state[j2]);
            }
        }
    }

    private void intToOctet(byte[] buf, int i2) {
        buf[0] = i2 >> 24;
        buf[1] = (byte)(i2 >>> 16);
        buf[2] = (byte)(i2 >>> 8);
        buf[3] = (byte)i2;
    }

    private byte[] generateDerivedKey(int dkLen) {
        int hLen = this.hMac.getMacSize();
        int l2 = (dkLen + hLen - 1) / hLen;
        byte[] iBuf = new byte[4];
        byte[] out = new byte[l2 * hLen];
        for (int i2 = 1; i2 <= l2; ++i2) {
            this.intToOctet(iBuf, i2);
            this.F(this.password, this.salt, this.iterationCount, iBuf, out, (i2 - 1) * hLen);
        }
        return out;
    }

    @Override
    public CipherParameters generateDerivedParameters(int keySize) {
        byte[] dKey = this.generateDerivedKey(keySize /= 8);
        return new KeyParameter(dKey, 0, keySize);
    }

    @Override
    public CipherParameters generateDerivedParameters(int keySize, int ivSize) {
        byte[] dKey = this.generateDerivedKey((keySize /= 8) + (ivSize /= 8));
        return new ParametersWithIV(new KeyParameter(dKey, 0, keySize), dKey, keySize, ivSize);
    }

    @Override
    public CipherParameters generateDerivedMacParameters(int keySize) {
        return this.generateDerivedParameters(keySize);
    }
}

