/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.math.ntru.polynomial;

import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.IntegerPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.LongPolynomial5;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.TernaryPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.util.Util;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class DenseTernaryPolynomial
extends IntegerPolynomial
implements TernaryPolynomial {
    DenseTernaryPolynomial(int N) {
        super(N);
        this.checkTernarity();
    }

    public DenseTernaryPolynomial(IntegerPolynomial intPoly) {
        this(intPoly.coeffs);
    }

    public DenseTernaryPolynomial(int[] coeffs) {
        super(coeffs);
        this.checkTernarity();
    }

    private void checkTernarity() {
        for (int i2 = 0; i2 != this.coeffs.length; ++i2) {
            int c2 = this.coeffs[i2];
            if (c2 >= -1 && c2 <= 1) continue;
            throw new IllegalStateException("Illegal value: " + c2 + ", must be one of {-1, 0, 1}");
        }
    }

    public static DenseTernaryPolynomial generateRandom(int N, int numOnes, int numNegOnes, SecureRandom random) {
        int[] coeffs = Util.generateRandomTernary(N, numOnes, numNegOnes, random);
        return new DenseTernaryPolynomial(coeffs);
    }

    public static DenseTernaryPolynomial generateRandom(int N, SecureRandom random) {
        DenseTernaryPolynomial poly = new DenseTernaryPolynomial(N);
        for (int i2 = 0; i2 < N; ++i2) {
            poly.coeffs[i2] = random.nextInt(3) - 1;
        }
        return poly;
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial poly2, int modulus) {
        if (modulus == 2048) {
            IntegerPolynomial poly2Pos = (IntegerPolynomial)poly2.clone();
            poly2Pos.modPositive(2048);
            LongPolynomial5 poly5 = new LongPolynomial5(poly2Pos);
            return poly5.mult(this).toIntegerPolynomial();
        }
        return super.mult(poly2, modulus);
    }

    @Override
    public int[] getOnes() {
        int N = this.coeffs.length;
        int[] ones = new int[N];
        int onesIdx = 0;
        for (int i2 = 0; i2 < N; ++i2) {
            int c2 = this.coeffs[i2];
            if (c2 != 1) continue;
            ones[onesIdx++] = i2;
        }
        return Arrays.copyOf(ones, onesIdx);
    }

    @Override
    public int[] getNegOnes() {
        int N = this.coeffs.length;
        int[] negOnes = new int[N];
        int negOnesIdx = 0;
        for (int i2 = 0; i2 < N; ++i2) {
            int c2 = this.coeffs[i2];
            if (c2 != -1) continue;
            negOnes[negOnesIdx++] = i2;
        }
        return Arrays.copyOf(negOnes, negOnesIdx);
    }

    @Override
    public int size() {
        return this.coeffs.length;
    }
}

