/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.util;

import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;

public class WinternitzOTSignature {
    private Digest messDigestOTS;
    private int mdsize;
    private int keysize;
    private byte[][] privateKeyOTS;
    private int w;
    private GMSSRandom gmssRandom;
    private int messagesize;
    private int checksumsize;

    public WinternitzOTSignature(byte[] seed0, Digest digest, int w2) {
        this.w = w2;
        this.messDigestOTS = digest;
        this.gmssRandom = new GMSSRandom(this.messDigestOTS);
        this.mdsize = this.messDigestOTS.getDigestSize();
        int mdsizeBit = this.mdsize << 3;
        this.messagesize = (int)Math.ceil((double)mdsizeBit / (double)w2);
        this.checksumsize = this.getLog((this.messagesize << w2) + 1);
        this.keysize = this.messagesize + (int)Math.ceil((double)this.checksumsize / (double)w2);
        this.privateKeyOTS = new byte[this.keysize][this.mdsize];
        byte[] dummy = new byte[this.mdsize];
        System.arraycopy(seed0, 0, dummy, 0, dummy.length);
        for (int i2 = 0; i2 < this.keysize; ++i2) {
            this.privateKeyOTS[i2] = this.gmssRandom.nextSeed(dummy);
        }
    }

    public byte[][] getPrivateKey() {
        return this.privateKeyOTS;
    }

    public byte[] getPublicKey() {
        byte[] helppubKey = new byte[this.keysize * this.mdsize];
        int two_power_t = 1 << this.w;
        for (int i2 = 0; i2 < this.keysize; ++i2) {
            this.messDigestOTS.update(this.privateKeyOTS[i2], 0, this.privateKeyOTS[i2].length);
            byte[] help = new byte[this.messDigestOTS.getDigestSize()];
            this.messDigestOTS.doFinal(help, 0);
            for (int j2 = 2; j2 < two_power_t; ++j2) {
                this.messDigestOTS.update(help, 0, help.length);
                help = new byte[this.messDigestOTS.getDigestSize()];
                this.messDigestOTS.doFinal(help, 0);
            }
            System.arraycopy(help, 0, helppubKey, this.mdsize * i2, this.mdsize);
        }
        this.messDigestOTS.update(helppubKey, 0, helppubKey.length);
        byte[] tmp = new byte[this.messDigestOTS.getDigestSize()];
        this.messDigestOTS.doFinal(tmp, 0);
        return tmp;
    }

    public byte[] getSignature(byte[] message) {
        byte[] sign;
        block23: {
            long test8;
            int j2;
            int ii;
            long big8;
            int rest;
            int s2;
            byte[] hash;
            int c2;
            int counter;
            block24: {
                int j3;
                int test2;
                long big82;
                int i2;
                block22: {
                    int test2;
                    int i3;
                    sign = new byte[this.keysize * this.mdsize];
                    counter = 0;
                    c2 = 0;
                    this.messDigestOTS.update(message, 0, message.length);
                    hash = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hash, 0);
                    if (8 % this.w != 0) break block22;
                    int d2 = 8 / this.w;
                    int k2 = (1 << this.w) - 1;
                    byte[] hlp = new byte[this.mdsize];
                    for (i3 = 0; i3 < hash.length; ++i3) {
                        for (int j4 = 0; j4 < d2; ++j4) {
                            c2 += test2;
                            System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                            for (test2 = hash[i3] & k2; test2 > 0; --test2) {
                                this.messDigestOTS.update(hlp, 0, hlp.length);
                                hlp = new byte[this.messDigestOTS.getDigestSize()];
                                this.messDigestOTS.doFinal(hlp, 0);
                            }
                            System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                            hash[i3] = (byte)(hash[i3] >>> this.w);
                            ++counter;
                        }
                    }
                    c2 = (this.messagesize << this.w) - c2;
                    for (i3 = 0; i3 < this.checksumsize; i3 += this.w) {
                        System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                        for (test2 = c2 & k2; test2 > 0; --test2) {
                            this.messDigestOTS.update(hlp, 0, hlp.length);
                            hlp = new byte[this.messDigestOTS.getDigestSize()];
                            this.messDigestOTS.doFinal(hlp, 0);
                        }
                        System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                        c2 >>>= this.w;
                        ++counter;
                    }
                    break block23;
                }
                if (this.w >= 8) break block24;
                int d3 = this.mdsize / this.w;
                int k3 = (1 << this.w) - 1;
                byte[] hlp = new byte[this.mdsize];
                int ii2 = 0;
                for (i2 = 0; i2 < d3; ++i2) {
                    int j5;
                    big82 = 0L;
                    for (j5 = 0; j5 < this.w; ++j5) {
                        big82 ^= (long)((hash[ii2] & 0xFF) << (j5 << 3));
                        ++ii2;
                    }
                    for (j5 = 0; j5 < 8; ++j5) {
                        c2 += test2;
                        System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                        for (test2 = (int)(big82 & (long)k3); test2 > 0; --test2) {
                            this.messDigestOTS.update(hlp, 0, hlp.length);
                            hlp = new byte[this.messDigestOTS.getDigestSize()];
                            this.messDigestOTS.doFinal(hlp, 0);
                        }
                        System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                        big82 >>>= this.w;
                        ++counter;
                    }
                }
                d3 = this.mdsize % this.w;
                big82 = 0L;
                for (j3 = 0; j3 < d3; ++j3) {
                    big82 ^= (long)((hash[ii2] & 0xFF) << (j3 << 3));
                    ++ii2;
                }
                d3 <<= 3;
                for (j3 = 0; j3 < d3; j3 += this.w) {
                    c2 += test2;
                    System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                    for (test2 = (int)(big82 & (long)k3); test2 > 0; --test2) {
                        this.messDigestOTS.update(hlp, 0, hlp.length);
                        hlp = new byte[this.messDigestOTS.getDigestSize()];
                        this.messDigestOTS.doFinal(hlp, 0);
                    }
                    System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                    big82 >>>= this.w;
                    ++counter;
                }
                c2 = (this.messagesize << this.w) - c2;
                for (i2 = 0; i2 < this.checksumsize; i2 += this.w) {
                    System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                    for (test2 = c2 & k3; test2 > 0; --test2) {
                        this.messDigestOTS.update(hlp, 0, hlp.length);
                        hlp = new byte[this.messDigestOTS.getDigestSize()];
                        this.messDigestOTS.doFinal(hlp, 0);
                    }
                    System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                    c2 >>>= this.w;
                    ++counter;
                }
                break block23;
            }
            if (this.w >= 57) break block23;
            int d4 = (this.mdsize << 3) - this.w;
            int k4 = (1 << this.w) - 1;
            byte[] hlp = new byte[this.mdsize];
            int r2 = 0;
            while (r2 <= d4) {
                s2 = r2 >>> 3;
                rest = r2 % 8;
                int f2 = (r2 += this.w) + 7 >>> 3;
                big8 = 0L;
                ii = 0;
                for (j2 = s2; j2 < f2; ++j2) {
                    big8 ^= (long)((hash[j2] & 0xFF) << (ii << 3));
                    ++ii;
                }
                c2 = (int)((long)c2 + test8);
                System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                for (test8 = (big8 >>>= rest) & (long)k4; test8 > 0L; --test8) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                ++counter;
            }
            s2 = r2 >>> 3;
            if (s2 < this.mdsize) {
                rest = r2 % 8;
                big8 = 0L;
                ii = 0;
                for (j2 = s2; j2 < this.mdsize; ++j2) {
                    big8 ^= (long)((hash[j2] & 0xFF) << (ii << 3));
                    ++ii;
                }
                c2 = (int)((long)c2 + test8);
                System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                for (test8 = (big8 >>>= rest) & (long)k4; test8 > 0L; --test8) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                ++counter;
            }
            c2 = (this.messagesize << this.w) - c2;
            for (int i4 = 0; i4 < this.checksumsize; i4 += this.w) {
                System.arraycopy(this.privateKeyOTS[counter], 0, hlp, 0, this.mdsize);
                for (test8 = (long)(c2 & k4); test8 > 0L; --test8) {
                    this.messDigestOTS.update(hlp, 0, hlp.length);
                    hlp = new byte[this.messDigestOTS.getDigestSize()];
                    this.messDigestOTS.doFinal(hlp, 0);
                }
                System.arraycopy(hlp, 0, sign, counter * this.mdsize, this.mdsize);
                c2 >>>= this.w;
                ++counter;
            }
        }
        return sign;
    }

    public int getLog(int intValue) {
        int log = 1;
        int i2 = 2;
        while (i2 < intValue) {
            i2 <<= 1;
            ++log;
        }
        return log;
    }
}

