/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util;

import com.timevale.tgtext.bouncycastle.crypto.BlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.BufferedBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DataLengthException;
import com.timevale.tgtext.bouncycastle.crypto.InvalidCipherTextException;
import com.timevale.tgtext.bouncycastle.crypto.OutputLengthException;
import com.timevale.tgtext.bouncycastle.crypto.modes.AEADBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.modes.CBCBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.modes.CCMBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.modes.CFBBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.modes.CTSBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.modes.EAXBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.modes.GCMBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.modes.GOFBBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.modes.OFBBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.modes.OpenPGPCFBBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.modes.PGPCFBBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.modes.SICBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.paddings.BlockCipherPadding;
import com.timevale.tgtext.bouncycastle.crypto.paddings.ISO10126d2Padding;
import com.timevale.tgtext.bouncycastle.crypto.paddings.ISO7816d4Padding;
import com.timevale.tgtext.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.paddings.TBCPadding;
import com.timevale.tgtext.bouncycastle.crypto.paddings.X923Padding;
import com.timevale.tgtext.bouncycastle.crypto.paddings.ZeroBytePadding;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithIV;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithSBox;
import com.timevale.tgtext.bouncycastle.crypto.params.RC2Parameters;
import com.timevale.tgtext.bouncycastle.crypto.params.RC5Parameters;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.BaseWrapCipher;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.PBE;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import com.timevale.tgtext.bouncycastle.jce.spec.GOST28147ParameterSpec;
import com.timevale.tgtext.bouncycastle.jce.spec.RepeatedSecretKeySpec;
import com.timevale.tgtext.bouncycastle.util.Strings;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;

public class BaseBlockCipher
extends BaseWrapCipher
implements PBE {
    private Class[] availableSpecs = new Class[]{RC2ParameterSpec.class, RC5ParameterSpec.class, IvParameterSpec.class, PBEParameterSpec.class, GOST28147ParameterSpec.class};
    private BlockCipher baseEngine;
    private c cipher;
    private ParametersWithIV ivParam;
    private int ivLength = 0;
    private boolean padded;
    private PBEParameterSpec pbeSpec = null;
    private String pbeAlgorithm = null;
    private String modeName = null;

    protected BaseBlockCipher(BlockCipher engine) {
        this.baseEngine = engine;
        this.cipher = new b(engine);
    }

    protected BaseBlockCipher(BlockCipher engine, int ivLength) {
        this.baseEngine = engine;
        this.cipher = new b(engine);
        this.ivLength = ivLength / 8;
    }

    protected BaseBlockCipher(BufferedBlockCipher engine, int ivLength) {
        this.baseEngine = engine.getUnderlyingCipher();
        this.cipher = new b(engine);
        this.ivLength = ivLength / 8;
    }

    @Override
    protected int engineGetBlockSize() {
        return this.baseEngine.getBlockSize();
    }

    @Override
    protected byte[] engineGetIV() {
        if (this.ivParam != null) {
            return this.ivParam.getIV();
        }
        return null;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length << 3;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.cipher.a(inputLen);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null) {
            if (this.pbeSpec != null) {
                try {
                    this.engineParams = AlgorithmParameters.getInstance(this.pbeAlgorithm, BouncyCastleProvider.PROVIDER_NAME);
                    this.engineParams.init(this.pbeSpec);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (this.ivParam != null) {
                String name = this.cipher.c().getAlgorithmName();
                if (name.indexOf(47) >= 0) {
                    name = name.substring(0, name.indexOf(47));
                }
                try {
                    this.engineParams = AlgorithmParameters.getInstance(name, BouncyCastleProvider.PROVIDER_NAME);
                    this.engineParams.init(this.ivParam.getIV());
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2.toString());
                }
            }
        }
        return this.engineParams;
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        this.modeName = Strings.toUpperCase(mode);
        if (this.modeName.equals("ECB")) {
            this.ivLength = 0;
            this.cipher = new b(this.baseEngine);
            return;
        }
        if (this.modeName.equals("CBC")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new b(new CBCBlockCipher(this.baseEngine));
            return;
        }
        if (this.modeName.startsWith("OFB")) {
            this.ivLength = this.baseEngine.getBlockSize();
            if (this.modeName.length() != 3) {
                int wordSize = Integer.parseInt(this.modeName.substring(3));
                this.cipher = new b(new OFBBlockCipher(this.baseEngine, wordSize));
                return;
            }
            this.cipher = new b(new OFBBlockCipher(this.baseEngine, 8 * this.baseEngine.getBlockSize()));
            return;
        }
        if (this.modeName.startsWith("CFB")) {
            this.ivLength = this.baseEngine.getBlockSize();
            if (this.modeName.length() != 3) {
                int wordSize = Integer.parseInt(this.modeName.substring(3));
                this.cipher = new b(new CFBBlockCipher(this.baseEngine, wordSize));
                return;
            }
            this.cipher = new b(new CFBBlockCipher(this.baseEngine, 8 * this.baseEngine.getBlockSize()));
            return;
        }
        if (this.modeName.startsWith("PGP")) {
            boolean inlineIV = this.modeName.equalsIgnoreCase("PGPCFBwithIV");
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new b(new PGPCFBBlockCipher(this.baseEngine, inlineIV));
            return;
        }
        if (this.modeName.equalsIgnoreCase("OpenPGPCFB")) {
            this.ivLength = 0;
            this.cipher = new b(new OpenPGPCFBBlockCipher(this.baseEngine));
            return;
        }
        if (this.modeName.startsWith("SIC")) {
            this.ivLength = this.baseEngine.getBlockSize();
            if (this.ivLength < 16) {
                throw new IllegalArgumentException("Warning: SIC-Mode can become a twotime-pad if the blocksize of the cipher is too small. Use a cipher with a block size of at least 128 bits (e.g. AES)");
            }
            this.cipher = new b(new BufferedBlockCipher(new SICBlockCipher(this.baseEngine)));
            return;
        }
        if (this.modeName.startsWith("CTR")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new b(new BufferedBlockCipher(new SICBlockCipher(this.baseEngine)));
            return;
        }
        if (this.modeName.startsWith("GOFB")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new b(new BufferedBlockCipher(new GOFBBlockCipher(this.baseEngine)));
            return;
        }
        if (this.modeName.startsWith("CTS")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new b(new CTSBlockCipher(new CBCBlockCipher(this.baseEngine)));
            return;
        }
        if (this.modeName.startsWith("CCM")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new a(new CCMBlockCipher(this.baseEngine));
            return;
        }
        if (this.modeName.startsWith("EAX")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new a(new EAXBlockCipher(this.baseEngine));
            return;
        }
        if (this.modeName.startsWith("GCM")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new a(new GCMBlockCipher(this.baseEngine));
            return;
        }
        throw new NoSuchAlgorithmException("can't support mode " + mode);
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        String paddingName = Strings.toUpperCase(padding);
        if (paddingName.equals("NOPADDING")) {
            if (this.cipher.b()) {
                this.cipher = new b(new BufferedBlockCipher(this.cipher.c()));
                return;
            }
        } else {
            if (paddingName.equals("WITHCTS")) {
                this.cipher = new b(new CTSBlockCipher(this.cipher.c()));
                return;
            }
            this.padded = true;
            if (this.isAEADModeName(this.modeName)) {
                throw new NoSuchPaddingException("Only NoPadding can be used with AEAD modes.");
            }
            if (paddingName.equals("PKCS5PADDING") || paddingName.equals("PKCS7PADDING")) {
                this.cipher = new b(this.cipher.c());
                return;
            }
            if (paddingName.equals("ZEROBYTEPADDING")) {
                this.cipher = new b(this.cipher.c(), new ZeroBytePadding());
                return;
            }
            if (paddingName.equals("ISO10126PADDING") || paddingName.equals("ISO10126-2PADDING")) {
                this.cipher = new b(this.cipher.c(), new ISO10126d2Padding());
                return;
            }
            if (paddingName.equals("X9.23PADDING") || paddingName.equals("X923PADDING")) {
                this.cipher = new b(this.cipher.c(), new X923Padding());
                return;
            }
            if (paddingName.equals("ISO7816-4PADDING") || paddingName.equals("ISO9797-1PADDING")) {
                this.cipher = new b(this.cipher.c(), new ISO7816d4Padding());
                return;
            }
            if (paddingName.equals("TBCPADDING")) {
                this.cipher = new b(this.cipher.c(), new TBCPadding());
                return;
            }
            throw new NoSuchPaddingException("Padding " + padding + " unknown.");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters param;
        this.pbeSpec = null;
        this.pbeAlgorithm = null;
        this.engineParams = null;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key for algorithm " + key.getAlgorithm() + " not suitable for symmetric enryption.");
        }
        if (params == null && this.baseEngine.getAlgorithmName().startsWith("RC5-64")) {
            throw new InvalidAlgorithmParameterException("RC5 requires an RC5ParametersSpec to be passed in.");
        }
        if (key instanceof BCPBEKey) {
            BCPBEKey k2 = (BCPBEKey)key;
            this.pbeAlgorithm = k2.getOID() != null ? k2.getOID().getId() : k2.getAlgorithm();
            if (k2.getParam() != null) {
                param = k2.getParam();
                this.pbeSpec = new PBEParameterSpec(k2.getSalt(), k2.getIterationCount());
            } else if (params instanceof PBEParameterSpec) {
                this.pbeSpec = (PBEParameterSpec)params;
                param = PBE.Util.makePBEParameters(k2, params, this.cipher.c().getAlgorithmName());
            } else {
                throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
            }
            if (param instanceof ParametersWithIV) {
                this.ivParam = (ParametersWithIV)param;
            }
        } else if (params == null) {
            param = new KeyParameter(key.getEncoded());
        } else if (params instanceof IvParameterSpec) {
            if (this.ivLength != 0) {
                IvParameterSpec p2 = (IvParameterSpec)params;
                if (p2.getIV().length != this.ivLength && !this.isAEADModeName(this.modeName)) {
                    throw new InvalidAlgorithmParameterException("IV must be " + this.ivLength + " bytes long.");
                }
                if (key instanceof RepeatedSecretKeySpec) {
                    param = new ParametersWithIV(null, p2.getIV());
                    this.ivParam = (ParametersWithIV)param;
                } else {
                    param = new ParametersWithIV(new KeyParameter(key.getEncoded()), p2.getIV());
                    this.ivParam = (ParametersWithIV)param;
                }
            } else {
                if (this.modeName != null && this.modeName.equals("ECB")) {
                    throw new InvalidAlgorithmParameterException("ECB mode does not use an IV");
                }
                param = new KeyParameter(key.getEncoded());
            }
        } else if (params instanceof GOST28147ParameterSpec) {
            GOST28147ParameterSpec gost28147Param = (GOST28147ParameterSpec)params;
            param = new ParametersWithSBox(new KeyParameter(key.getEncoded()), ((GOST28147ParameterSpec)params).getSbox());
            if (gost28147Param.getIV() != null && this.ivLength != 0) {
                param = new ParametersWithIV(param, gost28147Param.getIV());
                this.ivParam = (ParametersWithIV)param;
            }
        } else if (params instanceof RC2ParameterSpec) {
            RC2ParameterSpec rc2Param = (RC2ParameterSpec)params;
            param = new RC2Parameters(key.getEncoded(), ((RC2ParameterSpec)params).getEffectiveKeyBits());
            if (rc2Param.getIV() != null && this.ivLength != 0) {
                param = new ParametersWithIV(param, rc2Param.getIV());
                this.ivParam = (ParametersWithIV)param;
            }
        } else if (params instanceof RC5ParameterSpec) {
            RC5ParameterSpec rc5Param = (RC5ParameterSpec)params;
            param = new RC5Parameters(key.getEncoded(), ((RC5ParameterSpec)params).getRounds());
            if (this.baseEngine.getAlgorithmName().startsWith("RC5")) {
                if (this.baseEngine.getAlgorithmName().equals("RC5-32")) {
                    if (rc5Param.getWordSize() != 32) {
                        throw new InvalidAlgorithmParameterException("RC5 already set up for a word size of 32 not " + rc5Param.getWordSize() + ".");
                    }
                } else if (this.baseEngine.getAlgorithmName().equals("RC5-64") && rc5Param.getWordSize() != 64) {
                    throw new InvalidAlgorithmParameterException("RC5 already set up for a word size of 64 not " + rc5Param.getWordSize() + ".");
                }
            } else {
                throw new InvalidAlgorithmParameterException("RC5 parameters passed to a cipher that is not RC5.");
            }
            if (rc5Param.getIV() != null && this.ivLength != 0) {
                param = new ParametersWithIV(param, rc5Param.getIV());
                this.ivParam = (ParametersWithIV)param;
            }
        } else {
            throw new InvalidAlgorithmParameterException("unknown parameter type.");
        }
        if (this.ivLength != 0 && !(param instanceof ParametersWithIV)) {
            SecureRandom ivRandom = random;
            if (ivRandom == null) {
                ivRandom = new SecureRandom();
            }
            if (opmode == 1 || opmode == 3) {
                byte[] iv = new byte[this.ivLength];
                ivRandom.nextBytes(iv);
                param = new ParametersWithIV(param, iv);
                this.ivParam = (ParametersWithIV)param;
            } else if (this.cipher.c().getAlgorithmName().indexOf("PGPCFB") < 0) {
                throw new InvalidAlgorithmParameterException("no IV set when one expected");
            }
        }
        if (random != null && this.padded) {
            param = new ParametersWithRandom(param, random);
        }
        try {
            switch (opmode) {
                case 1: 
                case 3: {
                    this.cipher.a(true, param);
                    break;
                }
                case 2: 
                case 4: {
                    this.cipher.a(false, param);
                    break;
                }
                default: {
                    throw new InvalidParameterException("unknown opmode " + opmode + " passed");
                }
            }
        }
        catch (Exception e2) {
            throw new InvalidKeyException(e2.getMessage());
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec paramSpec = null;
        if (params != null) {
            for (int i2 = 0; i2 != this.availableSpecs.length; ++i2) {
                try {
                    paramSpec = (AlgorithmParameterSpec)params.getParameterSpec(this.availableSpecs[i2]);
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (paramSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + params.toString());
            }
        }
        this.engineInit(opmode, key, paramSpec, random);
        this.engineParams = params;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
            return;
        }
        catch (InvalidAlgorithmParameterException e2) {
            throw new InvalidKeyException(e2.getMessage());
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        int length = this.cipher.b(inputLen);
        if (length > 0) {
            byte[] out = new byte[length];
            int len = this.cipher.a(input, inputOffset, inputLen, out, 0);
            if (len == 0) {
                return null;
            }
            if (len != length) {
                byte[] tmp = new byte[len];
                System.arraycopy(out, 0, tmp, 0, len);
                return tmp;
            }
            return out;
        }
        this.cipher.a(input, inputOffset, inputLen, null, 0);
        return null;
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        try {
            return this.cipher.a(input, inputOffset, inputLen, output, outputOffset);
        }
        catch (DataLengthException e2) {
            throw new ShortBufferException(e2.getMessage());
        }
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        int len = 0;
        byte[] tmp = new byte[this.engineGetOutputSize(inputLen)];
        if (inputLen != 0) {
            len = this.cipher.a(input, inputOffset, inputLen, tmp, 0);
        }
        try {
            len += this.cipher.a(tmp, len);
        }
        catch (DataLengthException e2) {
            throw new IllegalBlockSizeException(e2.getMessage());
        }
        catch (InvalidCipherTextException e3) {
            throw new BadPaddingException(e3.getMessage());
        }
        if (len == tmp.length) {
            return tmp;
        }
        byte[] out = new byte[len];
        System.arraycopy(tmp, 0, out, 0, len);
        return out;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        try {
            int len = 0;
            if (inputLen != 0) {
                len = this.cipher.a(input, inputOffset, inputLen, output, outputOffset);
            }
            return len + this.cipher.a(output, outputOffset + len);
        }
        catch (OutputLengthException e2) {
            throw new ShortBufferException(e2.getMessage());
        }
        catch (DataLengthException e3) {
            throw new IllegalBlockSizeException(e3.getMessage());
        }
        catch (InvalidCipherTextException e4) {
            throw new BadPaddingException(e4.getMessage());
        }
    }

    private boolean isAEADModeName(String modeName) {
        return "CCM".equals(modeName) || "EAX".equals(modeName) || "GCM".equals(modeName);
    }

    private static class a
    implements c {
        private AEADBlockCipher a;

        a(AEADBlockCipher cipher) {
            this.a = cipher;
        }

        @Override
        public void a(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
            this.a.init(forEncryption, params);
        }

        @Override
        public String a() {
            return this.a.getUnderlyingCipher().getAlgorithmName();
        }

        @Override
        public boolean b() {
            return false;
        }

        @Override
        public BlockCipher c() {
            return this.a.getUnderlyingCipher();
        }

        @Override
        public int a(int len) {
            return this.a.getOutputSize(len);
        }

        @Override
        public int b(int len) {
            return this.a.getUpdateOutputSize(len);
        }

        @Override
        public int a(byte in, byte[] out, int outOff) throws DataLengthException {
            return this.a.processByte(in, out, outOff);
        }

        @Override
        public int a(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
            return this.a.processBytes(in, inOff, len, out, outOff);
        }

        @Override
        public int a(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
            return this.a.doFinal(out, outOff);
        }
    }

    private static class b
    implements c {
        private BufferedBlockCipher a;

        b(BufferedBlockCipher cipher) {
            this.a = cipher;
        }

        b(BlockCipher cipher) {
            this.a = new PaddedBufferedBlockCipher(cipher);
        }

        b(BlockCipher cipher, BlockCipherPadding padding) {
            this.a = new PaddedBufferedBlockCipher(cipher, padding);
        }

        @Override
        public void a(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
            this.a.init(forEncryption, params);
        }

        @Override
        public boolean b() {
            return !(this.a instanceof CTSBlockCipher);
        }

        @Override
        public String a() {
            return this.a.getUnderlyingCipher().getAlgorithmName();
        }

        @Override
        public BlockCipher c() {
            return this.a.getUnderlyingCipher();
        }

        @Override
        public int a(int len) {
            return this.a.getOutputSize(len);
        }

        @Override
        public int b(int len) {
            return this.a.getUpdateOutputSize(len);
        }

        @Override
        public int a(byte in, byte[] out, int outOff) throws DataLengthException {
            return this.a.processByte(in, out, outOff);
        }

        @Override
        public int a(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
            return this.a.processBytes(in, inOff, len, out, outOff);
        }

        @Override
        public int a(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
            return this.a.doFinal(out, outOff);
        }
    }

    private static interface c {
        public void a(boolean var1, CipherParameters var2) throws IllegalArgumentException;

        public boolean b();

        public String a();

        public BlockCipher c();

        public int a(int var1);

        public int b(int var1);

        public int a(byte var1, byte[] var2, int var3) throws DataLengthException;

        public int a(byte[] var1, int var2, int var3, byte[] var4, int var5) throws DataLengthException;

        public int a(byte[] var1, int var2) throws IllegalStateException, InvalidCipherTextException;
    }
}

