/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.operator.bc;

import com.timevale.tgtext.bouncycastle.crypto.CryptoException;
import com.timevale.tgtext.bouncycastle.crypto.Signer;
import java.io.IOException;
import java.io.OutputStream;

public class BcSignerOutputStream
extends OutputStream {
    private Signer sig;

    BcSignerOutputStream(Signer sig) {
        this.sig = sig;
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        this.sig.update(bytes, off, len);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.sig.update(bytes, 0, bytes.length);
    }

    @Override
    public void write(int b2) throws IOException {
        this.sig.update((byte)b2);
    }

    byte[] getSignature() throws CryptoException {
        return this.sig.generateSignature();
    }

    boolean verify(byte[] expected) {
        return this.sig.verifySignature(expected);
    }
}

