/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.crmf;

import com.timevale.tgtext.bouncycastle.asn1.DERBitString;
import com.timevale.tgtext.bouncycastle.asn1.crmf.CertRequest;
import com.timevale.tgtext.bouncycastle.asn1.crmf.PKMACValue;
import com.timevale.tgtext.bouncycastle.asn1.crmf.POPOSigningKey;
import com.timevale.tgtext.bouncycastle.asn1.crmf.POPOSigningKeyInput;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.cert.crmf.CRMFException;
import com.timevale.tgtext.bouncycastle.cert.crmf.a;
import com.timevale.tgtext.bouncycastle.cert.crmf.b;
import com.timevale.tgtext.bouncycastle.operator.ContentSigner;

public class ProofOfPossessionSigningKeyBuilder {
    private CertRequest certRequest;
    private SubjectPublicKeyInfo pubKeyInfo;
    private GeneralName name;
    private PKMACValue publicKeyMAC;

    public ProofOfPossessionSigningKeyBuilder(CertRequest certRequest) {
        this.certRequest = certRequest;
    }

    public ProofOfPossessionSigningKeyBuilder(SubjectPublicKeyInfo pubKeyInfo) {
        this.pubKeyInfo = pubKeyInfo;
    }

    public ProofOfPossessionSigningKeyBuilder setSender(GeneralName name) {
        this.name = name;
        return this;
    }

    public ProofOfPossessionSigningKeyBuilder setPublicKeyMac(b generator, char[] password) throws CRMFException {
        this.publicKeyMAC = generator.a(password, this.pubKeyInfo);
        return this;
    }

    public POPOSigningKey build(ContentSigner signer) {
        POPOSigningKeyInput popo;
        if (this.name != null && this.publicKeyMAC != null) {
            throw new IllegalStateException("name and publicKeyMAC cannot both be set.");
        }
        if (this.certRequest != null) {
            popo = null;
            a.a(this.certRequest, signer.getOutputStream());
        } else if (this.name != null) {
            popo = new POPOSigningKeyInput(this.name, this.pubKeyInfo);
            a.a(popo, signer.getOutputStream());
        } else {
            popo = new POPOSigningKeyInput(this.publicKeyMAC, this.pubKeyInfo);
            a.a(popo, signer.getOutputStream());
        }
        return new POPOSigningKey(popo, signer.getAlgorithmIdentifier(), new DERBitString(signer.getSignature()));
    }
}

