/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.mail.smime;

import com.timevale.tgtext.bouncycastle.cms.CMSEnvelopedGenerator;
import com.timevale.tgtext.bouncycastle.mail.smime.SMIMEException;
import com.timevale.tgtext.bouncycastle.util.Strings;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.mail.internet.j;
import javax.mail.internet.k;
import javax.mail.q;
import javax.mail.s;

public class SMIMEGenerator {
    private static Map BASE_CIPHER_NAMES = new HashMap<String, String>();
    protected boolean useBase64 = true;
    protected String encoding = "base64";

    protected SMIMEGenerator() {
    }

    public void setContentTransferEncoding(String string) {
        this.encoding = string;
        this.useBase64 = Strings.toLowerCase(string).equals("base64");
    }

    protected j makeContentBodyPart(j j2) throws SMIMEException {
        try {
            javax.mail.k k2;
            k k3 = new k(null);
            Enumeration enumeration = j2.getAllHeaders();
            k3.setDataHandler(j2.getDataHandler());
            while (enumeration.hasMoreElements()) {
                k2 = (javax.mail.k)enumeration.nextElement();
                k3.setHeader(k2.a(), k2.b());
            }
            k3.b_();
            enumeration = k3.getAllHeaders();
            while (enumeration.hasMoreElements()) {
                k2 = (javax.mail.k)enumeration.nextElement();
                if (!Strings.toLowerCase(k2.a()).startsWith("content-")) continue;
                j2.setHeader(k2.a(), k2.b());
            }
        }
        catch (q q2) {
            throw new SMIMEException("exception saving message state.", (Exception)((Object)q2));
        }
        return j2;
    }

    protected j makeContentBodyPart(k k2) throws SMIMEException {
        j j2 = new j();
        try {
            k2.removeHeader("Message-Id");
            k2.removeHeader("Mime-Version");
            try {
                if (k2.getContent() instanceof s) {
                    j2.setContent((Object)k2.A(), k2.getContentType());
                    this.extractHeaders(j2, k2);
                    return j2;
                }
            }
            catch (q q2) {}
            j2.setContent(k2.getContent(), k2.getContentType());
            j2.setDataHandler(k2.getDataHandler());
            this.extractHeaders(j2, k2);
        }
        catch (q q3) {
            throw new SMIMEException("exception saving message state.", (Exception)((Object)q3));
        }
        catch (IOException iOException) {
            throw new SMIMEException("exception getting message content.", iOException);
        }
        return j2;
    }

    private void extractHeaders(j j2, k k2) throws q {
        Enumeration enumeration = k2.getAllHeaders();
        while (enumeration.hasMoreElements()) {
            javax.mail.k k3 = (javax.mail.k)enumeration.nextElement();
            j2.addHeader(k3.a(), k3.b());
        }
    }

    protected KeyGenerator createSymmetricKeyGenerator(String string, Provider provider) throws NoSuchAlgorithmException {
        try {
            return this.createKeyGenerator(string, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                String string2 = (String)BASE_CIPHER_NAMES.get(string);
                if (string2 != null) {
                    return this.createKeyGenerator(string2, provider);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {}
            if (provider != null) {
                return this.createSymmetricKeyGenerator(string, null);
            }
            throw noSuchAlgorithmException;
        }
    }

    private KeyGenerator createKeyGenerator(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider != null) {
            return KeyGenerator.getInstance(string, provider);
        }
        return KeyGenerator.getInstance(string);
    }

    static {
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.DES_EDE3_CBC, "DESEDE");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.AES128_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.AES192_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.AES256_CBC, "AES");
    }
}

