/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.ocsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERBitString;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.OCSPRequest;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.Request;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.Signature;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.TBSRequest;
import com.timevale.tgtext.bouncycastle.asn1.x500.X500Name;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extensions;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.ocsp.CertificateID;
import com.timevale.tgtext.bouncycastle.cert.ocsp.OCSPException;
import com.timevale.tgtext.bouncycastle.cert.ocsp.OCSPReq;
import com.timevale.tgtext.bouncycastle.operator.ContentSigner;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OCSPReqBuilder {
    private List list = new ArrayList();
    private GeneralName requestorName = null;
    private Extensions requestExtensions = null;

    public OCSPReqBuilder addRequest(CertificateID certId) {
        this.list.add(new a(certId, null));
        return this;
    }

    public OCSPReqBuilder addRequest(CertificateID certId, Extensions singleRequestExtensions) {
        this.list.add(new a(certId, singleRequestExtensions));
        return this;
    }

    public OCSPReqBuilder setRequestorName(X500Name requestorName) {
        this.requestorName = new GeneralName(4, requestorName);
        return this;
    }

    public OCSPReqBuilder setRequestorName(GeneralName requestorName) {
        this.requestorName = requestorName;
        return this;
    }

    public OCSPReqBuilder setRequestExtensions(Extensions requestExtensions) {
        this.requestExtensions = requestExtensions;
        return this;
    }

    private OCSPReq generateRequest(ContentSigner contentSigner, X509CertificateHolder[] chain) throws OCSPException {
        Iterator it = this.list.iterator();
        ASN1EncodableVector requests = new ASN1EncodableVector();
        while (it.hasNext()) {
            try {
                requests.add(((a)it.next()).a());
            }
            catch (Exception e2) {
                throw new OCSPException("exception creating Request", e2);
            }
        }
        TBSRequest tbsReq = new TBSRequest(this.requestorName, (ASN1Sequence)new DERSequence(requests), this.requestExtensions);
        Signature signature = null;
        if (contentSigner != null) {
            if (this.requestorName == null) {
                throw new OCSPException("requestorName must be specified if request is signed.");
            }
            try {
                OutputStream sOut = contentSigner.getOutputStream();
                sOut.write(tbsReq.getEncoded("DER"));
                sOut.close();
            }
            catch (Exception e3) {
                throw new OCSPException("exception processing TBSRequest: " + e3, e3);
            }
            DERBitString bitSig = new DERBitString(contentSigner.getSignature());
            AlgorithmIdentifier sigAlgId = contentSigner.getAlgorithmIdentifier();
            if (chain != null && chain.length > 0) {
                ASN1EncodableVector v2 = new ASN1EncodableVector();
                for (int i2 = 0; i2 != chain.length; ++i2) {
                    v2.add(chain[i2].toASN1Structure());
                }
                signature = new Signature(sigAlgId, bitSig, new DERSequence(v2));
            } else {
                signature = new Signature(sigAlgId, bitSig);
            }
        }
        return new OCSPReq(new OCSPRequest(tbsReq, signature));
    }

    public OCSPReq build() throws OCSPException {
        return this.generateRequest(null, null);
    }

    public OCSPReq build(ContentSigner signer, X509CertificateHolder[] chain) throws OCSPException, IllegalArgumentException {
        if (signer == null) {
            throw new IllegalArgumentException("no signer specified");
        }
        return this.generateRequest(signer, chain);
    }

    private class a {
        CertificateID a;
        Extensions b;

        public a(CertificateID certId, Extensions extensions) {
            this.a = certId;
            this.b = extensions;
        }

        public Request a() throws Exception {
            return new Request(this.a.toASN1Object(), this.b);
        }
    }
}

