/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Set;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.BERSequenceGenerator;
import com.timevale.tgtext.bouncycastle.asn1.BERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERSet;
import com.timevale.tgtext.bouncycastle.asn1.cms.AttributeTable;
import com.timevale.tgtext.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.cms.SignerInfo;
import com.timevale.tgtext.bouncycastle.cms.CMSAttributeTableGenerator;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.CMSProcessable;
import com.timevale.tgtext.bouncycastle.cms.CMSSignedGenerator;
import com.timevale.tgtext.bouncycastle.cms.CMSStreamException;
import com.timevale.tgtext.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import com.timevale.tgtext.bouncycastle.cms.SignerInfoGenerator;
import com.timevale.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.tgtext.bouncycastle.cms.SimpleAttributeTableGenerator;
import com.timevale.tgtext.bouncycastle.cms.h;
import com.timevale.tgtext.bouncycastle.cms.i;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import com.timevale.tgtext.bouncycastle.operator.ContentSigner;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import com.timevale.tgtext.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CMSSignedDataStreamGenerator
extends CMSSignedGenerator {
    private int _bufferSize;

    public CMSSignedDataStreamGenerator() {
    }

    public CMSSignedDataStreamGenerator(SecureRandom rand) {
        super(rand);
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, digestOID, i.a(sigProvider));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), null, sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, encryptionOID, digestOID, i.a(sigProvider));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, encryptionOID, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), null, sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, digestOID, signedAttr, unsignedAttr, i.a(sigProvider));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, cert, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(signedAttr), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(unsignedAttr), sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, encryptionOID, digestOID, signedAttr, unsignedAttr, i.a(sigProvider));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, cert, encryptionOID, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(signedAttr), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(unsignedAttr), sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, digestOID, signedAttrGenerator, unsignedAttrGenerator, i.a(sigProvider));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, cert, this.getEncOID(key, digestOID), digestOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, encryptionOID, digestOID, signedAttrGenerator, unsignedAttrGenerator, i.a(sigProvider));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, cert, encryptionOID, digestOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider, sigProvider);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, digestOID, i.a(sigProvider));
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), null, sigProvider);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, encryptionOID, digestOID, i.a(sigProvider));
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, encryptionOID, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), null, sigProvider);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, digestOID, signedAttr, unsignedAttr, i.a(sigProvider));
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(signedAttr), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(unsignedAttr), sigProvider);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, digestOID, signedAttrGenerator, unsignedAttrGenerator, i.a(sigProvider));
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, this.getEncOID(key, digestOID), digestOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, encryptionOID, digestOID, signedAttrGenerator, unsignedAttrGenerator, i.a(sigProvider));
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, encryptionOID, digestOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider, sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider, Provider digProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.doAddSigner(key, cert, encryptionOID, digestOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider, digProvider);
    }

    private void doAddSigner(PrivateKey key, Object signerId, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider, Provider digProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        block12: {
            JcaContentSignerBuilder signerBuilder;
            String digestName = h.a.a(digestOID);
            String signatureName = digestName + "with" + h.a.b(encryptionOID);
            try {
                signerBuilder = new JcaContentSignerBuilder(signatureName).setSecureRandom(this.rand);
            }
            catch (IllegalArgumentException e2) {
                throw new NoSuchAlgorithmException(e2.getMessage());
            }
            if (sigProvider != null) {
                signerBuilder.setProvider(sigProvider);
            }
            try {
                block11: {
                    JcaDigestCalculatorProviderBuilder calculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder();
                    if (digProvider != null && !digProvider.getName().equalsIgnoreCase("SunRsaSign")) {
                        calculatorProviderBuilder.setProvider(digProvider);
                    }
                    JcaSignerInfoGeneratorBuilder builder = new JcaSignerInfoGeneratorBuilder(calculatorProviderBuilder.build());
                    builder.setSignedAttributeGenerator(signedAttrGenerator);
                    builder.setUnsignedAttributeGenerator(unsignedAttrGenerator);
                    try {
                        ContentSigner contentSigner = signerBuilder.build(key);
                        if (signerId instanceof X509Certificate) {
                            this.addSignerInfoGenerator(builder.build(contentSigner, (X509Certificate)signerId));
                            break block11;
                        }
                        this.addSignerInfoGenerator(builder.build(contentSigner, (byte[])signerId));
                        break block12;
                    }
                    catch (OperatorCreationException operatorCreationException) {
                        OperatorCreationException e3 = operatorCreationException;
                        if (operatorCreationException.getCause() instanceof NoSuchAlgorithmException) {
                            throw (NoSuchAlgorithmException)e3.getCause();
                        }
                        if (!(e3.getCause() instanceof InvalidKeyException)) break block11;
                        throw (InvalidKeyException)e3.getCause();
                    }
                }
                return;
            }
            catch (OperatorCreationException e4) {
                throw new NoSuchAlgorithmException("unable to create operators: " + e4.getMessage());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IllegalStateException("unable to encode certificate");
            }
        }
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider, Provider digProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.doAddSigner(key, subjectKeyID, encryptionOID, digestOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider, digProvider);
    }

    public OutputStream open(OutputStream out) throws IOException {
        return this.open(out, false);
    }

    public OutputStream open(OutputStream out, boolean encapsulate) throws IOException {
        return this.open(CMSObjectIdentifiers.data, out, encapsulate);
    }

    public OutputStream open(OutputStream out, boolean encapsulate, OutputStream dataOutputStream) throws IOException {
        return this.open(CMSObjectIdentifiers.data, out, encapsulate, dataOutputStream);
    }

    public OutputStream open(OutputStream out, String eContentType, boolean encapsulate) throws IOException {
        return this.open(out, eContentType, encapsulate, null);
    }

    public OutputStream open(ASN1ObjectIdentifier eContentType, OutputStream out, boolean encapsulate) throws IOException {
        return this.open(eContentType, out, encapsulate, null);
    }

    public OutputStream open(OutputStream out, String eContentType, boolean encapsulate, OutputStream dataOutputStream) throws IOException {
        return this.open(new ASN1ObjectIdentifier(eContentType), out, encapsulate, dataOutputStream);
    }

    public OutputStream open(ASN1ObjectIdentifier eContentType, OutputStream out, boolean encapsulate, OutputStream dataOutputStream) throws IOException {
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject(this.calculateVersion(eContentType));
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        for (SignerInformation signer : this._signers) {
            digestAlgs.add(h.a.a(signer.getDigestAlgorithmID()));
        }
        for (SignerInfoGenerator signerGen : this.signerGens) {
            digestAlgs.add(signerGen.getDigestAlgorithm());
        }
        sigGen.getRawOutputStream().write(new DERSet(digestAlgs).getEncoded());
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject(eContentType);
        OutputStream encapStream = encapsulate ? i.a(eiGen.getRawOutputStream(), 0, true, this._bufferSize) : null;
        OutputStream contentStream = i.a(dataOutputStream, encapStream);
        OutputStream sigStream = i.a((Collection)this.signerGens, contentStream);
        return new a(sigStream, eContentType, sGen, sigGen, eiGen);
    }

    void generate(OutputStream out, String eContentType, boolean encapsulate, OutputStream dataOutputStream, CMSProcessable content) throws CMSException, IOException {
        OutputStream signedOut = this.open(out, eContentType, encapsulate, dataOutputStream);
        if (content != null) {
            content.write(signedOut);
        }
        signedOut.close();
    }

    private ASN1Integer calculateVersion(ASN1ObjectIdentifier contentOid) {
        boolean otherCert = false;
        boolean otherCrl = false;
        boolean attrCertV1Found = false;
        boolean attrCertV2Found = false;
        if (this.certs != null) {
            for (Object obj : this.certs) {
                if (!(obj instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject tagged = (ASN1TaggedObject)obj;
                if (tagged.getTagNo() == 1) {
                    attrCertV1Found = true;
                    continue;
                }
                if (tagged.getTagNo() == 2) {
                    attrCertV2Found = true;
                    continue;
                }
                if (tagged.getTagNo() != 3) continue;
                otherCert = true;
            }
        }
        if (otherCert) {
            return new ASN1Integer(5L);
        }
        if (this.crls != null) {
            for (Object obj : this.crls) {
                if (!(obj instanceof ASN1TaggedObject)) continue;
                otherCrl = true;
            }
        }
        if (otherCrl) {
            return new ASN1Integer(5L);
        }
        if (attrCertV2Found) {
            return new ASN1Integer(4L);
        }
        if (attrCertV1Found) {
            return new ASN1Integer(3L);
        }
        if (this.checkForVersion3(this._signers, this.signerGens)) {
            return new ASN1Integer(3L);
        }
        if (!CMSObjectIdentifiers.data.equals(contentOid)) {
            return new ASN1Integer(3L);
        }
        return new ASN1Integer(1L);
    }

    private boolean checkForVersion3(List signerInfos, List signerInfoGens) {
        Iterator it = signerInfos.iterator();
        while (it.hasNext()) {
            Object s2 = SignerInfo.getInstance(((SignerInformation)it.next()).toASN1Structure());
            if (((SignerInfo)s2).getVersion().getValue().intValue() != 3) continue;
            return true;
        }
        for (Object s2 : signerInfoGens) {
            if (((SignerInfoGenerator)s2).getGeneratedVersion().getValue().intValue() != 3) continue;
            return true;
        }
        return false;
    }

    private class a
    extends OutputStream {
        private OutputStream b;
        private ASN1ObjectIdentifier c;
        private BERSequenceGenerator d;
        private BERSequenceGenerator e;
        private BERSequenceGenerator f;

        public a(OutputStream out, ASN1ObjectIdentifier contentOID, BERSequenceGenerator sGen, BERSequenceGenerator sigGen, BERSequenceGenerator eiGen) {
            this.b = out;
            this.c = contentOID;
            this.d = sGen;
            this.e = sigGen;
            this.f = eiGen;
        }

        @Override
        public void write(int b2) throws IOException {
            this.b.write(b2);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.b.write(bytes, off, len);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.b.write(bytes);
        }

        @Override
        public void close() throws IOException {
            this.b.close();
            this.f.close();
            CMSSignedDataStreamGenerator.this.digests.clear();
            if (CMSSignedDataStreamGenerator.this.certs.size() != 0) {
                ASN1Set certSet = i.a(CMSSignedDataStreamGenerator.this.certs);
                this.e.getRawOutputStream().write(new BERTaggedObject(false, 0, certSet).getEncoded());
            }
            if (CMSSignedDataStreamGenerator.this.crls.size() != 0) {
                ASN1Set crlSet = i.a(CMSSignedDataStreamGenerator.this.crls);
                this.e.getRawOutputStream().write(new BERTaggedObject(false, 1, crlSet).getEncoded());
            }
            ASN1EncodableVector signerInfos = new ASN1EncodableVector();
            for (SignerInfoGenerator sigGen : CMSSignedDataStreamGenerator.this.signerGens) {
                try {
                    signerInfos.add(sigGen.generate(this.c));
                    byte[] calculatedDigest = sigGen.getCalculatedDigest();
                    CMSSignedDataStreamGenerator.this.digests.put(sigGen.getDigestAlgorithm().getAlgorithm().getId(), calculatedDigest);
                }
                catch (CMSException e2) {
                    throw new CMSStreamException("exception generating signers: " + e2.getMessage(), e2);
                }
            }
            for (SignerInformation signer : CMSSignedDataStreamGenerator.this._signers) {
                signerInfos.add(signer.toASN1Structure());
            }
            this.e.getRawOutputStream().write(new DERSet(signerInfos).getEncoded());
            this.e.close();
            this.d.close();
        }
    }
}

