/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.crypto.tls.Certificate;
import com.timevale.tgtext.bouncycastle.crypto.tls.CertificateRequest;
import com.timevale.tgtext.bouncycastle.crypto.tls.CertificateVerifyer;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsAuthentication;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsCredentials;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import java.io.IOException;

public class LegacyTlsAuthentication
implements TlsAuthentication {
    protected CertificateVerifyer verifyer;

    public LegacyTlsAuthentication(CertificateVerifyer verifyer) {
        this.verifyer = verifyer;
    }

    @Override
    public void notifyServerCertificate(Certificate serverCertificate) throws IOException {
        if (!this.verifyer.isValid(serverCertificate.getCerts())) {
            throw new TlsFatalAlert(90);
        }
    }

    @Override
    public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
        return null;
    }
}

