/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.mail.smime.examples;

import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import com.timevale.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.tgtext.bouncycastle.cms.SignerInformationStore;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import com.timevale.tgtext.bouncycastle.mail.smime.SMIMESigned;
import com.timevale.tgtext.bouncycastle.util.Store;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.ad;
import javax.mail.d;
import javax.mail.internet.j;
import javax.mail.internet.k;
import javax.mail.internet.l;
import javax.mail.s;
import javax.mail.v;

public class ReadSignedMail {
    private static final String BC = BouncyCastleProvider.PROVIDER_NAME;

    private static void verify(SMIMESigned sMIMESigned) throws Exception {
        Store store = sMIMESigned.getCertificates();
        SignerInformationStore signerInformationStore = sMIMESigned.getSignerInfos();
        Collection collection = signerInformationStore.getSigners();
        for (SignerInformation signerInformation : collection) {
            Collection collection2 = store.getMatches(signerInformation.getSID());
            Iterator iterator = collection2.iterator();
            X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider(BC).getCertificate((X509CertificateHolder)iterator.next());
            if (signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(x509Certificate))) {
                System.out.println("signature verified");
                continue;
            }
            System.out.println("signature failed!");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Properties properties = System.getProperties();
        ad ad2 = ad.b((Properties)properties, null);
        k k2 = new k(ad2, (InputStream)new FileInputStream("signed.message"));
        if (k2.isMimeType("multipart/signed")) {
            SMIMESigned sMIMESigned = new SMIMESigned((l)k2.getContent());
            j j2 = sMIMESigned.getContent();
            System.out.println("Content:");
            Object object = j2.getContent();
            if (object instanceof String) {
                System.out.println((String)object);
            } else if (object instanceof s) {
                s s2 = (s)object;
                int n2 = s2.d();
                for (int i2 = 0; i2 < n2; ++i2) {
                    d d2 = s2.a(i2);
                    Object object2 = d2.getContent();
                    System.out.println("Part " + i2);
                    System.out.println("---------------------------");
                    if (object2 instanceof String) {
                        System.out.println((String)object2);
                        continue;
                    }
                    System.out.println("can't print...");
                }
            }
            System.out.println("Status:");
            ReadSignedMail.verify(sMIMESigned);
            return;
        }
        if (k2.isMimeType("application/pkcs7-mime") || k2.isMimeType("application/x-pkcs7-mime")) {
            SMIMESigned sMIMESigned = new SMIMESigned((v)k2);
            j j3 = sMIMESigned.getContent();
            System.out.println("Content:");
            Object object = j3.getContent();
            if (object instanceof String) {
                System.out.println((String)object);
            }
            System.out.println("Status:");
            ReadSignedMail.verify(sMIMESigned);
            return;
        }
        System.err.println("Not a signed message!");
    }
}

