/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pkcs.bc;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.crypto.BlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.BufferedBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.ExtendedDigest;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA1Digest;
import com.timevale.tgtext.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import com.timevale.tgtext.bouncycastle.crypto.io.CipherOutputStream;
import com.timevale.tgtext.bouncycastle.crypto.paddings.PKCS7Padding;
import com.timevale.tgtext.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.timevale.tgtext.bouncycastle.operator.GenericKey;
import com.timevale.tgtext.bouncycastle.operator.OutputEncryptor;
import com.timevale.tgtext.bouncycastle.pkcs.bc.a;
import java.io.OutputStream;
import java.security.SecureRandom;

public class BcPKCS12PBEOutputEncryptorBuilder {
    private ExtendedDigest digest;
    private BufferedBlockCipher engine;
    private ASN1ObjectIdentifier algorithm;
    private SecureRandom random;

    public BcPKCS12PBEOutputEncryptorBuilder(ASN1ObjectIdentifier algorithm, BlockCipher engine) {
        this(algorithm, engine, new SHA1Digest());
    }

    public BcPKCS12PBEOutputEncryptorBuilder(ASN1ObjectIdentifier algorithm, BlockCipher engine, ExtendedDigest pbeDigest) {
        this.algorithm = algorithm;
        this.engine = new PaddedBufferedBlockCipher(engine, new PKCS7Padding());
        this.digest = pbeDigest;
    }

    public OutputEncryptor build(final char[] password) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byte[] salt = new byte[20];
        this.random.nextBytes(salt);
        final PKCS12PBEParams pbeParams = new PKCS12PBEParams(salt, 1024);
        CipherParameters params = a.a(this.algorithm, this.digest, this.engine.getBlockSize(), pbeParams, password);
        this.engine.init(true, params);
        return new OutputEncryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return new AlgorithmIdentifier(BcPKCS12PBEOutputEncryptorBuilder.this.algorithm, (ASN1Encodable)pbeParams);
            }

            @Override
            public OutputStream getOutputStream(OutputStream out) {
                return new CipherOutputStream(out, BcPKCS12PBEOutputEncryptorBuilder.this.engine);
            }

            @Override
            public GenericKey getKey() {
                return new GenericKey(PKCS12ParametersGenerator.PKCS12PasswordToBytes(password));
            }
        };
    }
}

