/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.math.ntru.euclid;

import java.math.BigInteger;

public class BigIntEuclidean {
    public BigInteger x;
    public BigInteger y;
    public BigInteger gcd;

    private BigIntEuclidean() {
    }

    public static BigIntEuclidean calculate(BigInteger a2, BigInteger b2) {
        BigInteger x2 = BigInteger.ZERO;
        BigInteger lastx = BigInteger.ONE;
        BigInteger y2 = BigInteger.ONE;
        BigInteger lasty = BigInteger.ZERO;
        while (!b2.equals(BigInteger.ZERO)) {
            BigInteger[] quotientAndRemainder = a2.divideAndRemainder(b2);
            BigInteger quotient = quotientAndRemainder[0];
            a2 = b2;
            b2 = quotientAndRemainder[1];
            BigInteger temp = x2;
            x2 = lastx.subtract(quotient.multiply(x2));
            lastx = temp;
            temp = y2;
            y2 = lasty.subtract(quotient.multiply(y2));
            lasty = temp;
        }
        BigIntEuclidean result = new BigIntEuclidean();
        new BigIntEuclidean().x = lastx;
        result.y = lasty;
        result.gcd = a2;
        return result;
    }
}

