/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.signers;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DSA;
import com.timevale.tgtext.bouncycastle.crypto.params.ECKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.math.ec.ECAlgorithms;
import com.timevale.tgtext.bouncycastle.math.ec.ECConstants;
import com.timevale.tgtext.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECDSASigner
implements DSA,
ECConstants {
    ECKeyParameters key;
    SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
                return;
            }
            this.random = new SecureRandom();
            this.key = (ECPrivateKeyParameters)param;
            return;
        }
        this.key = (ECPublicKeyParameters)param;
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger r2;
        BigInteger d2;
        BigInteger k2;
        BigInteger s2;
        BigInteger n2 = this.key.getParameters().getN();
        BigInteger e2 = this.calculateE(n2, message);
        do {
            ECPoint p2;
            BigInteger x2;
            int nBitLength = n2.bitLength();
            while ((k2 = new BigInteger(nBitLength, this.random)).equals(ZERO) || k2.compareTo(n2) >= 0 || (r2 = (x2 = (p2 = this.key.getParameters().getG().multiply(k2)).getX().toBigInteger()).mod(n2)).equals(ZERO)) {
            }
            d2 = ((ECPrivateKeyParameters)this.key).getD();
        } while ((s2 = k2.modInverse(n2).multiply(e2.add(d2.multiply(r2))).mod(n2)).equals(ZERO));
        BigInteger[] bigIntegerArray = new BigInteger[2];
        BigInteger[] res = bigIntegerArray;
        bigIntegerArray[0] = r2;
        res[1] = s2;
        return res;
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r2, BigInteger s2) {
        BigInteger n2 = this.key.getParameters().getN();
        BigInteger e2 = this.calculateE(n2, message);
        if (r2.compareTo(ONE) < 0 || r2.compareTo(n2) >= 0) {
            return false;
        }
        if (s2.compareTo(ONE) < 0 || s2.compareTo(n2) >= 0) {
            return false;
        }
        BigInteger c2 = s2.modInverse(n2);
        BigInteger u1 = e2.multiply(c2).mod(n2);
        BigInteger u2 = r2.multiply(c2).mod(n2);
        ECPoint G = this.key.getParameters().getG();
        ECPoint Q = ((ECPublicKeyParameters)this.key).getQ();
        ECPoint point = ECAlgorithms.sumOfTwoMultiplies(G, u1, Q, u2);
        BigInteger v2 = point.getX().toBigInteger().mod(n2);
        return v2.equals(r2);
    }

    private BigInteger calculateE(BigInteger n2, byte[] message) {
        int messageBitLength;
        int log2n = n2.bitLength();
        if (log2n >= (messageBitLength = message.length << 3)) {
            return new BigInteger(1, message);
        }
        BigInteger trunc = new BigInteger(1, message);
        trunc = trunc.shiftRight(messageBitLength - log2n);
        return trunc;
    }
}

