/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Generator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BERGenerator
extends ASN1Generator {
    private boolean _tagged = false;
    private boolean _isExplicit;
    private int _tagNo;

    protected BERGenerator(OutputStream out) {
        super(out);
    }

    public BERGenerator(OutputStream out, int tagNo, boolean isExplicit) {
        super(out);
        this._tagged = true;
        this._isExplicit = isExplicit;
        this._tagNo = tagNo;
    }

    @Override
    public OutputStream getRawOutputStream() {
        return this._out;
    }

    private void writeHdr(int tag) throws IOException {
        this._out.write(tag);
        this._out.write(128);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void writeBERHeader(int tag) throws IOException {
        if (!this._tagged) {
            this.writeHdr(tag);
            return;
        }
        int tagNum = this._tagNo | 0x80;
        if (this._isExplicit) {
            this.writeHdr(tagNum | 0x20);
            this.writeHdr(tag);
            return;
        }
        if ((tag & 0x20) != 0) {
            this.writeHdr(tagNum | 0x20);
            return;
        }
        this.writeHdr(tagNum);
    }

    protected void writeBERBody(InputStream contentStream) throws IOException {
        int ch2;
        while ((ch2 = contentStream.read()) >= 0) {
            this._out.write(ch2);
        }
    }

    protected void writeBEREnd() throws IOException {
        this._out.write(0);
        this._out.write(0);
        if (this._tagged && this._isExplicit) {
            this._out.write(0);
            this._out.write(0);
        }
    }
}

