/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.digests;

import com.timevale.tgtext.bouncycastle.crypto.ExtendedDigest;
import com.timevale.tgtext.bouncycastle.util.Arrays;

public class SHA3Digest
implements ExtendedDigest {
    private static long[] KeccakRoundConstants = SHA3Digest.keccakInitializeRoundConstants();
    private static int[] KeccakRhoOffsets = SHA3Digest.keccakInitializeRhoOffsets();
    private byte[] state = new byte[200];
    private byte[] dataQueue = new byte[192];
    private int rate;
    private int bitsInQueue;
    private int fixedOutputLength;
    private boolean squeezing;
    private int bitsAvailableForSqueezing;
    private byte[] chunk;
    private byte[] oneByte;
    long[] C = new long[5];
    long[] tempA = new long[25];
    long[] chiC = new long[5];

    private static long[] keccakInitializeRoundConstants() {
        long[] keccakRoundConstants = new long[24];
        byte[] byArray = new byte[1];
        byte[] LFSRstate = byArray;
        byArray[0] = 1;
        for (int i2 = 0; i2 < 24; ++i2) {
            keccakRoundConstants[i2] = 0L;
            for (int j2 = 0; j2 < 7; ++j2) {
                int bitPosition = (1 << j2) - 1;
                if (!SHA3Digest.LFSR86540(LFSRstate)) continue;
                int n2 = i2;
                keccakRoundConstants[n2] = keccakRoundConstants[n2] ^ 1L << bitPosition;
            }
        }
        return keccakRoundConstants;
    }

    private static boolean LFSR86540(byte[] LFSR) {
        boolean result = (LFSR[0] & 1) != 0;
        LFSR[0] = (LFSR[0] & 0x80) != 0 ? (byte)(LFSR[0] << 1 ^ 0x71) : (byte)(LFSR[0] << 1);
        return result;
    }

    private static int[] keccakInitializeRhoOffsets() {
        int[] nArray = new int[25];
        int[] keccakRhoOffsets = nArray;
        nArray[0] = 0;
        int x2 = 1;
        int y2 = 0;
        for (int t2 = 0; t2 < 24; ++t2) {
            keccakRhoOffsets[x2 % 5 + 5 * (y2 % 5)] = (t2 + 1) * (t2 + 2) / 2 % 64;
            int newX = (0 * x2 + 1 * y2) % 5;
            int newY = (2 * x2 + 3 * y2) % 5;
            x2 = newX;
            y2 = newY;
        }
        return keccakRhoOffsets;
    }

    private void clearDataQueueSection(int off, int len) {
        for (int i2 = off; i2 != off + len; ++i2) {
            this.dataQueue[i2] = 0;
        }
    }

    public SHA3Digest() {
        this.init(0);
    }

    public SHA3Digest(int bitLength) {
        this.init(bitLength);
    }

    public SHA3Digest(SHA3Digest source) {
        System.arraycopy(source.state, 0, this.state, 0, source.state.length);
        System.arraycopy(source.dataQueue, 0, this.dataQueue, 0, source.dataQueue.length);
        this.rate = source.rate;
        this.bitsInQueue = source.bitsInQueue;
        this.fixedOutputLength = source.fixedOutputLength;
        this.squeezing = source.squeezing;
        this.bitsAvailableForSqueezing = source.bitsAvailableForSqueezing;
        this.chunk = Arrays.clone(source.chunk);
        this.oneByte = Arrays.clone(source.oneByte);
    }

    @Override
    public String getAlgorithmName() {
        return "SHA3-" + this.fixedOutputLength;
    }

    @Override
    public int getDigestSize() {
        return this.fixedOutputLength / 8;
    }

    @Override
    public void update(byte in) {
        this.oneByte[0] = in;
        this.doUpdate(this.oneByte, 0, 8L);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.doUpdate(in, inOff, (long)len << 3);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.squeeze(out, outOff, this.fixedOutputLength);
        this.reset();
        return this.getDigestSize();
    }

    @Override
    public void reset() {
        this.init(this.fixedOutputLength);
    }

    @Override
    public int getByteLength() {
        return this.rate / 8;
    }

    private void init(int bitLength) {
        switch (bitLength) {
            case 0: 
            case 288: {
                this.initSponge(1024, 576);
                return;
            }
            case 224: {
                this.initSponge(1152, 448);
                return;
            }
            case 256: {
                this.initSponge(1088, 512);
                return;
            }
            case 384: {
                this.initSponge(832, 768);
                return;
            }
            case 512: {
                this.initSponge(576, 1024);
                return;
            }
        }
        throw new IllegalArgumentException("bitLength must be one of 224, 256, 384, or 512.");
    }

    private void doUpdate(byte[] data, int off, long databitlen) {
        if (databitlen % 8L == 0L) {
            this.absorb(data, off, databitlen);
            return;
        }
        this.absorb(data, off, databitlen - databitlen % 8L);
        byte[] byArray = new byte[1];
        byte[] lastByte = byArray;
        byArray[0] = (byte)(data[off + (int)(databitlen / 8L)] >> (int)(8L - databitlen % 8L));
        this.absorb(lastByte, off, databitlen % 8L);
    }

    private void initSponge(int rate, int capacity) {
        if (rate + capacity != 1600) {
            throw new IllegalStateException("rate + capacity != 1600");
        }
        if (rate <= 0 || rate >= 1600 || rate % 64 != 0) {
            throw new IllegalStateException("invalid rate value");
        }
        this.rate = rate;
        this.fixedOutputLength = 0;
        Arrays.fill(this.state, (byte)0);
        Arrays.fill(this.dataQueue, (byte)0);
        this.bitsInQueue = 0;
        this.squeezing = false;
        this.bitsAvailableForSqueezing = 0;
        this.fixedOutputLength = capacity / 2;
        this.chunk = new byte[rate / 8];
        this.oneByte = new byte[1];
    }

    private void absorbQueue() {
        this.KeccakAbsorb(this.state, this.dataQueue, this.rate / 8);
        this.bitsInQueue = 0;
    }

    private void absorb(byte[] data, int off, long databitlen) {
        if (this.bitsInQueue % 8 != 0) {
            throw new IllegalStateException("attempt to absorb with odd length queue.");
        }
        if (this.squeezing) {
            throw new IllegalStateException("attempt to absorb while squeezing.");
        }
        long i2 = 0L;
        while (i2 < databitlen) {
            if (this.bitsInQueue == 0 && databitlen >= (long)this.rate && i2 <= databitlen - (long)this.rate) {
                long wholeBlocks = (databitlen - i2) / (long)this.rate;
                for (long j2 = 0L; j2 < wholeBlocks; ++j2) {
                    System.arraycopy(data, (int)((long)off + i2 / 8L + j2 * (long)this.chunk.length), this.chunk, 0, this.chunk.length);
                    this.KeccakAbsorb(this.state, this.chunk, this.chunk.length);
                }
                i2 += wholeBlocks * (long)this.rate;
                continue;
            }
            int partialBlock = (int)(databitlen - i2);
            if (partialBlock + this.bitsInQueue > this.rate) {
                partialBlock = this.rate - this.bitsInQueue;
            }
            int partialByte = partialBlock % 8;
            System.arraycopy(data, off + (int)(i2 / 8L), this.dataQueue, this.bitsInQueue / 8, (partialBlock -= partialByte) / 8);
            this.bitsInQueue += partialBlock;
            i2 += (long)partialBlock;
            if (this.bitsInQueue == this.rate) {
                this.absorbQueue();
            }
            if (partialByte <= 0) continue;
            int mask = (1 << partialByte) - 1;
            this.dataQueue[this.bitsInQueue / 8] = (byte)(data[off + (int)(i2 / 8L)] & mask);
            this.bitsInQueue += partialByte;
            i2 += (long)partialByte;
        }
    }

    private void padAndSwitchToSqueezingPhase() {
        if (this.bitsInQueue + 1 == this.rate) {
            int n2 = this.bitsInQueue / 8;
            this.dataQueue[n2] = (byte)(this.dataQueue[n2] | 1 << this.bitsInQueue % 8);
            this.absorbQueue();
            this.clearDataQueueSection(0, this.rate / 8);
        } else {
            this.clearDataQueueSection((this.bitsInQueue + 7) / 8, this.rate / 8 - (this.bitsInQueue + 7) / 8);
            int n3 = this.bitsInQueue / 8;
            this.dataQueue[n3] = (byte)(this.dataQueue[n3] | 1 << this.bitsInQueue % 8);
        }
        int n4 = (this.rate - 1) / 8;
        this.dataQueue[n4] = (byte)(this.dataQueue[n4] | 1 << (this.rate - 1) % 8);
        this.absorbQueue();
        if (this.rate == 1024) {
            this.KeccakExtract1024bits(this.state, this.dataQueue);
            this.bitsAvailableForSqueezing = 1024;
        } else {
            this.KeccakExtract(this.state, this.dataQueue, this.rate / 64);
            this.bitsAvailableForSqueezing = this.rate;
        }
        this.squeezing = true;
    }

    private void squeeze(byte[] output, int offset, long outputLength) {
        int partialBlock;
        if (!this.squeezing) {
            this.padAndSwitchToSqueezingPhase();
        }
        if (outputLength % 8L != 0L) {
            throw new IllegalStateException("outputLength not a multiple of 8");
        }
        for (long i2 = 0L; i2 < outputLength; i2 += (long)partialBlock) {
            if (this.bitsAvailableForSqueezing == 0) {
                this.keccakPermutation(this.state);
                if (this.rate == 1024) {
                    this.KeccakExtract1024bits(this.state, this.dataQueue);
                    this.bitsAvailableForSqueezing = 1024;
                } else {
                    this.KeccakExtract(this.state, this.dataQueue, this.rate / 64);
                    this.bitsAvailableForSqueezing = this.rate;
                }
            }
            if ((long)(partialBlock = this.bitsAvailableForSqueezing) > outputLength - i2) {
                partialBlock = (int)(outputLength - i2);
            }
            System.arraycopy(this.dataQueue, (this.rate - this.bitsAvailableForSqueezing) / 8, output, offset + (int)(i2 / 8L), partialBlock / 8);
            this.bitsAvailableForSqueezing -= partialBlock;
        }
    }

    private void fromBytesToWords(long[] stateAsWords, byte[] state) {
        for (int i2 = 0; i2 < 25; ++i2) {
            stateAsWords[i2] = 0L;
            int index = i2 << 3;
            for (int j2 = 0; j2 < 8; ++j2) {
                int n2 = i2;
                stateAsWords[n2] = stateAsWords[n2] | ((long)state[index + j2] & 0xFFL) << j2 * 8;
            }
        }
    }

    private void fromWordsToBytes(byte[] state, long[] stateAsWords) {
        for (int i2 = 0; i2 < 25; ++i2) {
            int index = i2 << 3;
            for (int j2 = 0; j2 < 8; ++j2) {
                state[index + j2] = (byte)(stateAsWords[i2] >>> j2 * 8 & 0xFFL);
            }
        }
    }

    private void keccakPermutation(byte[] state) {
        long[] longState = new long[state.length / 8];
        this.fromBytesToWords(longState, state);
        this.keccakPermutationOnWords(longState);
        this.fromWordsToBytes(state, longState);
    }

    private void keccakPermutationAfterXor(byte[] state, byte[] data, int dataLengthInBytes) {
        for (int i2 = 0; i2 < dataLengthInBytes; ++i2) {
            int n2 = i2;
            state[n2] = (byte)(state[n2] ^ data[i2]);
        }
        this.keccakPermutation(state);
    }

    private void keccakPermutationOnWords(long[] state) {
        for (int i2 = 0; i2 < 24; ++i2) {
            this.theta(state);
            this.rho(state);
            this.pi(state);
            this.chi(state);
            this.iota(state, i2);
        }
    }

    private void theta(long[] A) {
        int x2;
        for (x2 = 0; x2 < 5; ++x2) {
            this.C[x2] = 0L;
            for (int y2 = 0; y2 < 5; ++y2) {
                int n2 = x2;
                this.C[n2] = this.C[n2] ^ A[x2 + 5 * y2];
            }
        }
        for (x2 = 0; x2 < 5; ++x2) {
            long dX = this.C[(x2 + 1) % 5] << 1 ^ this.C[(x2 + 1) % 5] >>> 63 ^ this.C[(x2 + 4) % 5];
            for (int y3 = 0; y3 < 5; ++y3) {
                int n3 = x2 + 5 * y3;
                A[n3] = A[n3] ^ dX;
            }
        }
    }

    private void rho(long[] A) {
        for (int x2 = 0; x2 < 5; ++x2) {
            for (int y2 = 0; y2 < 5; ++y2) {
                int index = x2 + 5 * y2;
                A[index] = KeccakRhoOffsets[index] != 0 ? A[index] << KeccakRhoOffsets[index] ^ A[index] >>> 64 - KeccakRhoOffsets[index] : A[index];
            }
        }
    }

    private void pi(long[] A) {
        System.arraycopy(A, 0, this.tempA, 0, this.tempA.length);
        for (int x2 = 0; x2 < 5; ++x2) {
            for (int y2 = 0; y2 < 5; ++y2) {
                A[y2 + 5 * ((2 * x2 + 3 * y2) % 5)] = this.tempA[x2 + 5 * y2];
            }
        }
    }

    private void chi(long[] A) {
        for (int y2 = 0; y2 < 5; ++y2) {
            int x2;
            for (x2 = 0; x2 < 5; ++x2) {
                this.chiC[x2] = A[x2 + 5 * y2] ^ (A[(x2 + 1) % 5 + 5 * y2] ^ 0xFFFFFFFFFFFFFFFFL) & A[(x2 + 2) % 5 + 5 * y2];
            }
            for (x2 = 0; x2 < 5; ++x2) {
                A[x2 + 5 * y2] = this.chiC[x2];
            }
        }
    }

    private void iota(long[] A, int indexRound) {
        A[0] = A[0] ^ KeccakRoundConstants[indexRound];
    }

    private void KeccakAbsorb(byte[] byteState, byte[] data, int dataInBytes) {
        this.keccakPermutationAfterXor(byteState, data, dataInBytes);
    }

    private void KeccakExtract1024bits(byte[] byteState, byte[] data) {
        System.arraycopy(byteState, 0, data, 0, 128);
    }

    private void KeccakExtract(byte[] byteState, byte[] data, int laneCount) {
        System.arraycopy(byteState, 0, data, 0, laneCount << 3);
    }
}

