/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.tsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Boolean;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.tsp.MessageImprint;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extensions;

public class TimeStampReq
extends ASN1Object {
    ASN1Integer version;
    MessageImprint messageImprint;
    ASN1ObjectIdentifier tsaPolicy;
    ASN1Integer nonce;
    ASN1Boolean certReq;
    Extensions extensions;

    public static TimeStampReq getInstance(Object o2) {
        if (o2 instanceof TimeStampReq) {
            return (TimeStampReq)o2;
        }
        if (o2 != null) {
            return new TimeStampReq(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private TimeStampReq(ASN1Sequence seq) {
        int nbObjects = seq.size();
        this.version = ASN1Integer.getInstance(seq.getObjectAt(0));
        this.messageImprint = MessageImprint.getInstance(seq.getObjectAt(1));
        for (int opt = 2; opt < nbObjects; ++opt) {
            ASN1TaggedObject tagged;
            if (seq.getObjectAt(opt) instanceof ASN1ObjectIdentifier) {
                this.tsaPolicy = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(opt));
                continue;
            }
            if (seq.getObjectAt(opt) instanceof ASN1Integer) {
                this.nonce = ASN1Integer.getInstance(seq.getObjectAt(opt));
                continue;
            }
            if (seq.getObjectAt(opt) instanceof ASN1Boolean) {
                this.certReq = ASN1Boolean.getInstance(seq.getObjectAt(opt));
                continue;
            }
            if (!(seq.getObjectAt(opt) instanceof ASN1TaggedObject) || (tagged = (ASN1TaggedObject)seq.getObjectAt(opt)).getTagNo() != 0) continue;
            this.extensions = Extensions.getInstance(tagged, false);
        }
    }

    public TimeStampReq(MessageImprint messageImprint, ASN1ObjectIdentifier tsaPolicy, ASN1Integer nonce, ASN1Boolean certReq, Extensions extensions) {
        this.version = new ASN1Integer(1L);
        this.messageImprint = messageImprint;
        this.tsaPolicy = tsaPolicy;
        this.nonce = nonce;
        this.certReq = certReq;
        this.extensions = extensions;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public MessageImprint getMessageImprint() {
        return this.messageImprint;
    }

    public ASN1ObjectIdentifier getReqPolicy() {
        return this.tsaPolicy;
    }

    public ASN1Integer getNonce() {
        return this.nonce;
    }

    public ASN1Boolean getCertReq() {
        return this.certReq;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.version);
        v2.add(this.messageImprint);
        if (this.tsaPolicy != null) {
            v2.add(this.tsaPolicy);
        }
        if (this.nonce != null) {
            v2.add(this.nonce);
        }
        if (this.certReq != null && this.certReq.isTrue()) {
            v2.add(this.certReq);
        }
        if (this.extensions != null) {
            v2.add(new DERTaggedObject(false, 0, this.extensions));
        }
        return new DERSequence(v2);
    }
}

