/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.cmp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIStatusInfo;
import com.timevale.tgtext.bouncycastle.asn1.crmf.CertId;
import com.timevale.tgtext.bouncycastle.asn1.x509.CertificateList;
import java.util.Enumeration;

public class RevRepContent
extends ASN1Object {
    private ASN1Sequence status;
    private ASN1Sequence revCerts;
    private ASN1Sequence crls;

    private RevRepContent(ASN1Sequence seq) {
        Enumeration en2 = seq.getObjects();
        this.status = ASN1Sequence.getInstance(en2.nextElement());
        while (en2.hasMoreElements()) {
            ASN1TaggedObject tObj = ASN1TaggedObject.getInstance(en2.nextElement());
            if (tObj.getTagNo() == 0) {
                this.revCerts = ASN1Sequence.getInstance(tObj, true);
                continue;
            }
            this.crls = ASN1Sequence.getInstance(tObj, true);
        }
    }

    public static RevRepContent getInstance(Object o2) {
        if (o2 instanceof RevRepContent) {
            return (RevRepContent)o2;
        }
        if (o2 != null) {
            return new RevRepContent(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public PKIStatusInfo[] getStatus() {
        PKIStatusInfo[] results = new PKIStatusInfo[this.status.size()];
        for (int i2 = 0; i2 != results.length; ++i2) {
            results[i2] = PKIStatusInfo.getInstance(this.status.getObjectAt(i2));
        }
        return results;
    }

    public CertId[] getRevCerts() {
        if (this.revCerts == null) {
            return null;
        }
        CertId[] results = new CertId[this.revCerts.size()];
        for (int i2 = 0; i2 != results.length; ++i2) {
            results[i2] = CertId.getInstance(this.revCerts.getObjectAt(i2));
        }
        return results;
    }

    public CertificateList[] getCrls() {
        if (this.crls == null) {
            return null;
        }
        CertificateList[] results = new CertificateList[this.crls.size()];
        for (int i2 = 0; i2 != results.length; ++i2) {
            results[i2] = CertificateList.getInstance(this.crls.getObjectAt(i2));
        }
        return results;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.status);
        this.addOptional(v2, 0, this.revCerts);
        this.addOptional(v2, 1, this.crls);
        return new DERSequence(v2);
    }

    private void addOptional(ASN1EncodableVector v2, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v2.add(new DERTaggedObject(true, tagNo, obj));
        }
    }
}

