/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.text.pdf.security;

import com.timevale.tgtext.bouncycastle.cert.ocsp.BasicOCSPResp;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import com.timevale.tgtext.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampToken;
import com.timevale.tgtext.text.pdf.security.aj;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;

public class e {
    public static String a(X509Certificate cert, Collection<CRL> crls, Calendar calendar) {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        if (cert.hasUnsupportedCriticalExtension()) {
            for (String oid : cert.getCriticalExtensionOIDs()) {
                if ("2.5.29.15".equals(oid) && cert.getKeyUsage()[0]) continue;
                try {
                    if ("2.5.29.37".equals(oid) && cert.getExtendedKeyUsage().contains("1.3.6.1.5.5.7.3.8")) {
                        continue;
                    }
                }
                catch (CertificateParsingException certificateParsingException) {}
                return "Has unsupported critical extension";
            }
        }
        try {
            cert.checkValidity(calendar.getTime());
        }
        catch (Exception exception) {
            Exception e2 = exception;
            return exception.getMessage();
        }
        if (crls != null) {
            for (CRL crl : crls) {
                if (!crl.isRevoked(cert)) continue;
                return "Certificate revoked";
            }
        }
        return null;
    }

    public static List<aj> a(Certificate[] certs, KeyStore keystore, Collection<CRL> crls, Calendar calendar) {
        ArrayList<aj> result = new ArrayList<aj>();
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        for (int k2 = 0; k2 < certs.length; ++k2) {
            int j2;
            X509Certificate cert = (X509Certificate)certs[k2];
            String err = e.a(cert, crls, calendar);
            if (err != null) {
                result.add(new aj(cert, err));
            }
            try {
                Enumeration<String> aliases = keystore.aliases();
                while (aliases.hasMoreElements()) {
                    X509Certificate certStoreX509;
                    try {
                        String alias = aliases.nextElement();
                        if (!keystore.isCertificateEntry(alias)) continue;
                        certStoreX509 = (X509Certificate)keystore.getCertificate(alias);
                        if (e.a(certStoreX509, crls, calendar) != null) continue;
                    }
                    catch (Exception exception) {}
                    try {
                        cert.verify(certStoreX509.getPublicKey());
                        return result;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            catch (Exception exception) {}
            for (j2 = 0; j2 < certs.length; ++j2) {
                if (j2 == k2) continue;
                X509Certificate certNext = (X509Certificate)certs[j2];
                try {
                    cert.verify(certNext.getPublicKey());
                    break;
                }
                catch (Exception exception) {}
            }
            if (j2 != certs.length) continue;
            result.add(new aj(cert, "Cannot be verified against the KeyStore or the certificate chain"));
        }
        if (result.size() == 0) {
            result.add(new aj(null, "Invalid state. Possible circular certificate chain"));
        }
        return result;
    }

    public static List<aj> a(Certificate[] certs, KeyStore keystore, Calendar calendar) {
        return e.a(certs, keystore, null, calendar);
    }

    public static boolean a(BasicOCSPResp ocsp, KeyStore keystore, String provider) {
        if (provider == null) {
            provider = "BC";
        }
        try {
            Enumeration<String> aliases = keystore.aliases();
            while (aliases.hasMoreElements()) {
                try {
                    String alias = aliases.nextElement();
                    if (!keystore.isCertificateEntry(alias)) continue;
                    X509Certificate certStoreX509 = (X509Certificate)keystore.getCertificate(alias);
                    if (!ocsp.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider(provider).build(certStoreX509.getPublicKey()))) continue;
                    return true;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public static boolean a(TimeStampToken ts, KeyStore keystore, String provider) {
        if (provider == null) {
            provider = "BC";
        }
        try {
            Enumeration<String> aliases = keystore.aliases();
            while (aliases.hasMoreElements()) {
                try {
                    String alias = aliases.nextElement();
                    if (!keystore.isCertificateEntry(alias)) continue;
                    X509Certificate certStoreX509 = (X509Certificate)keystore.getCertificate(alias);
                    ts.isSignatureValid(new JcaSimpleSignerInfoVerifierBuilder().setProvider(provider).build(certStoreX509));
                    return true;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {}
        return false;
    }
}

