/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util;

import com.timevale.tgtext.bouncycastle.crypto.BlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DataLengthException;
import com.timevale.tgtext.bouncycastle.crypto.StreamBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.StreamCipher;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithIV;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.BaseWrapCipher;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.PBE;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;

public class BaseStreamCipher
extends BaseWrapCipher
implements PBE {
    private Class[] availableSpecs = new Class[]{RC2ParameterSpec.class, RC5ParameterSpec.class, IvParameterSpec.class, PBEParameterSpec.class};
    private StreamCipher cipher;
    private ParametersWithIV ivParam;
    private int ivLength = 0;
    private PBEParameterSpec pbeSpec = null;
    private String pbeAlgorithm = null;

    protected BaseStreamCipher(StreamCipher engine, int ivLength) {
        this.cipher = engine;
        this.ivLength = ivLength;
    }

    protected BaseStreamCipher(BlockCipher engine, int ivLength) {
        this.ivLength = ivLength;
        this.cipher = new StreamBlockCipher(engine);
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected byte[] engineGetIV() {
        if (this.ivParam != null) {
            return this.ivParam.getIV();
        }
        return null;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length << 3;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return inputLen;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.pbeSpec != null) {
            try {
                AlgorithmParameters engineParams = AlgorithmParameters.getInstance(this.pbeAlgorithm, BouncyCastleProvider.PROVIDER_NAME);
                engineParams.init(this.pbeSpec);
                return engineParams;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.engineParams;
    }

    @Override
    protected void engineSetMode(String mode) {
        if (!mode.equalsIgnoreCase("ECB")) {
            throw new IllegalArgumentException("can't support mode " + mode);
        }
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (!padding.equalsIgnoreCase("NoPadding")) {
            throw new NoSuchPaddingException("Padding " + padding + " unknown.");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters param;
        this.pbeSpec = null;
        this.pbeAlgorithm = null;
        this.engineParams = null;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key for algorithm " + key.getAlgorithm() + " not suitable for symmetric enryption.");
        }
        if (key instanceof BCPBEKey) {
            BCPBEKey k2 = (BCPBEKey)key;
            this.pbeAlgorithm = k2.getOID() != null ? k2.getOID().getId() : k2.getAlgorithm();
            if (k2.getParam() != null) {
                param = k2.getParam();
                this.pbeSpec = new PBEParameterSpec(k2.getSalt(), k2.getIterationCount());
            } else if (params instanceof PBEParameterSpec) {
                param = PBE.Util.makePBEParameters(k2, params, this.cipher.getAlgorithmName());
                this.pbeSpec = (PBEParameterSpec)params;
            } else {
                throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
            }
            if (k2.getIvSize() != 0) {
                this.ivParam = (ParametersWithIV)param;
            }
        } else if (params == null) {
            param = new KeyParameter(key.getEncoded());
        } else if (params instanceof IvParameterSpec) {
            param = new ParametersWithIV(new KeyParameter(key.getEncoded()), ((IvParameterSpec)params).getIV());
            this.ivParam = (ParametersWithIV)param;
        } else {
            throw new IllegalArgumentException("unknown parameter type.");
        }
        if (this.ivLength != 0 && !(param instanceof ParametersWithIV)) {
            SecureRandom ivRandom = random;
            if (ivRandom == null) {
                ivRandom = new SecureRandom();
            }
            if (opmode == 1 || opmode == 3) {
                byte[] iv = new byte[this.ivLength];
                ivRandom.nextBytes(iv);
                param = new ParametersWithIV(param, iv);
                this.ivParam = (ParametersWithIV)param;
            } else {
                throw new InvalidAlgorithmParameterException("no IV set when one expected");
            }
        }
        switch (opmode) {
            case 1: 
            case 3: {
                this.cipher.init(true, param);
                return;
            }
            case 2: 
            case 4: {
                this.cipher.init(false, param);
                return;
            }
        }
        System.out.println("eeek!");
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec paramSpec = null;
        if (params != null) {
            for (int i2 = 0; i2 != this.availableSpecs.length; ++i2) {
                try {
                    paramSpec = (AlgorithmParameterSpec)params.getParameterSpec(this.availableSpecs[i2]);
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (paramSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + params.toString());
            }
        }
        this.engineInit(opmode, key, paramSpec, random);
        this.engineParams = params;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
            return;
        }
        catch (InvalidAlgorithmParameterException e2) {
            throw new InvalidKeyException(e2.getMessage());
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        byte[] out = new byte[inputLen];
        this.cipher.processBytes(input, inputOffset, inputLen, out, 0);
        return out;
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        try {
            this.cipher.processBytes(input, inputOffset, inputLen, output, outputOffset);
            return inputLen;
        }
        catch (DataLengthException e2) {
            throw new ShortBufferException(e2.getMessage());
        }
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) {
        if (inputLen != 0) {
            byte[] out = this.engineUpdate(input, inputOffset, inputLen);
            this.cipher.reset();
            return out;
        }
        this.cipher.reset();
        return new byte[0];
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        if (inputLen != 0) {
            this.cipher.processBytes(input, inputOffset, inputLen, output, outputOffset);
        }
        this.cipher.reset();
        return inputLen;
    }
}

