/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.tsp.cms;

import com.timevale.tgtext.bouncycastle.asn1.DERIA5String;
import com.timevale.tgtext.bouncycastle.asn1.cms.AttributeTable;
import com.timevale.tgtext.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfoParser;
import com.timevale.tgtext.bouncycastle.asn1.cms.TimeStampedDataParser;
import com.timevale.tgtext.bouncycastle.cms.CMSContentInfoParser;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculator;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculatorProvider;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampToken;
import com.timevale.tgtext.bouncycastle.tsp.cms.ImprintDigestInvalidException;
import com.timevale.tgtext.bouncycastle.tsp.cms.b;
import com.timevale.tgtext.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;

public class CMSTimeStampedDataParser
extends CMSContentInfoParser {
    private TimeStampedDataParser timeStampedData;
    private b util;

    public CMSTimeStampedDataParser(InputStream in) throws CMSException {
        super(in);
        this.initialize(this._contentInfo);
    }

    public CMSTimeStampedDataParser(byte[] baseData) throws CMSException {
        this(new ByteArrayInputStream(baseData));
    }

    private void initialize(ContentInfoParser contentInfo) throws CMSException {
        try {
            if (!CMSObjectIdentifiers.timestampedData.equals(contentInfo.getContentType())) {
                throw new IllegalArgumentException("Malformed content - type must be " + CMSObjectIdentifiers.timestampedData.getId());
            }
            this.timeStampedData = TimeStampedDataParser.getInstance(contentInfo.getContent(16));
        }
        catch (IOException e2) {
            throw new CMSException("parsing exception: " + e2.getMessage(), e2);
        }
    }

    public byte[] calculateNextHash(DigestCalculator calculator) throws CMSException {
        return this.util.b(calculator);
    }

    public InputStream getContent() {
        if (this.timeStampedData.getContent() != null) {
            return this.timeStampedData.getContent().getOctetStream();
        }
        return null;
    }

    public URI getDataUri() throws URISyntaxException {
        DERIA5String dataURI = this.timeStampedData.getDataUri();
        if (dataURI != null) {
            return new URI(dataURI.getString());
        }
        return null;
    }

    public String getFileName() {
        return this.util.c();
    }

    public String getMediaType() {
        return this.util.d();
    }

    public AttributeTable getOtherMetaData() {
        return this.util.e();
    }

    public void initialiseMessageImprintDigestCalculator(DigestCalculator calculator) throws CMSException {
        this.util.a(calculator);
    }

    public DigestCalculator getMessageImprintDigestCalculator(DigestCalculatorProvider calculatorProvider) throws OperatorCreationException {
        try {
            this.parseTimeStamps();
        }
        catch (CMSException e2) {
            throw new OperatorCreationException("unable to extract algorithm ID: " + e2.getMessage(), e2);
        }
        return this.util.a(calculatorProvider);
    }

    public TimeStampToken[] getTimeStampTokens() throws CMSException {
        this.parseTimeStamps();
        return this.util.a();
    }

    public void validate(DigestCalculatorProvider calculatorProvider, byte[] dataDigest) throws ImprintDigestInvalidException, CMSException {
        this.parseTimeStamps();
        this.util.a(calculatorProvider, dataDigest);
    }

    public void validate(DigestCalculatorProvider calculatorProvider, byte[] dataDigest, TimeStampToken timeStampToken) throws ImprintDigestInvalidException, CMSException {
        this.parseTimeStamps();
        this.util.a(calculatorProvider, dataDigest, timeStampToken);
    }

    private void parseTimeStamps() throws CMSException {
        try {
            if (this.util == null) {
                InputStream cont = this.getContent();
                if (cont != null) {
                    Streams.drain(cont);
                }
                this.util = new b(this.timeStampedData);
            }
            return;
        }
        catch (IOException e2) {
            throw new CMSException("unable to parse evidence block: " + e2.getMessage(), e2);
        }
    }
}

