/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.jcajce.provider;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.timevale.tgtext.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.timevale.tgtext.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import com.timevale.tgtext.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;

public class BouncyCastlePQCProvider
extends Provider
implements ConfigurableProvider {
    private static String info = "BouncyCastle Post-Quantum Security Provider v1.48";
    public static String PROVIDER_NAME = "BCPQC";
    public static final ProviderConfiguration CONFIGURATION = null;
    private static final Map keyInfoConverters = new HashMap();
    private static final String ALGORITHM_PACKAGE = "com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.";
    private static final String[] ALGORITHMS = new String[]{"Rainbow", "McEliece"};

    public BouncyCastlePQCProvider() {
        super(PROVIDER_NAME, 1.48, info);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                BouncyCastlePQCProvider.this.setup();
                return null;
            }
        });
    }

    private void setup() {
        this.loadAlgorithms(ALGORITHM_PACKAGE, ALGORITHMS);
    }

    private void loadAlgorithms(String packageName, String[] names) {
        for (int i2 = 0; i2 != names.length; ++i2) {
            Class<?> clazz = null;
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                clazz = loader != null ? loader.loadClass(packageName + names[i2] + "$Mappings") : Class.forName(packageName + names[i2] + "$Mappings");
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (clazz == null) continue;
            try {
                ((AlgorithmProvider)clazz.newInstance()).configure(this);
                continue;
            }
            catch (Exception e2) {
                throw new InternalError("cannot create instance of " + packageName + names[i2] + "$Mappings : " + e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameter(String parameterName, Object parameter) {
        ProviderConfiguration providerConfiguration = CONFIGURATION;
        synchronized (providerConfiguration) {
            return;
        }
    }

    @Override
    public boolean hasAlgorithm(String type, String name) {
        return this.containsKey(type + "." + name) || this.containsKey("Alg.Alias." + type + "." + name);
    }

    @Override
    public void addAlgorithm(String key, String value) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.put(key, value);
    }

    @Override
    public void addKeyInfoConverter(ASN1ObjectIdentifier oid, AsymmetricKeyInfoConverter keyInfoConverter) {
        keyInfoConverters.put(oid, keyInfoConverter);
    }

    public static PublicKey getPublicKey(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter converter = (AsymmetricKeyInfoConverter)keyInfoConverters.get(publicKeyInfo.getAlgorithm().getAlgorithm());
        if (converter == null) {
            return null;
        }
        return converter.generatePublic(publicKeyInfo);
    }

    public static PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter converter = (AsymmetricKeyInfoConverter)keyInfoConverters.get(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        if (converter == null) {
            return null;
        }
        return converter.generatePrivate(privateKeyInfo);
    }
}

