/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.math.ntru.polynomial;

import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.BigIntPolynomial;
import java.math.BigDecimal;

public class BigDecimalPolynomial {
    private static final BigDecimal ZERO = new BigDecimal("0");
    private static final BigDecimal ONE_HALF = new BigDecimal("0.5");
    BigDecimal[] coeffs;

    BigDecimalPolynomial(int N) {
        this.coeffs = new BigDecimal[N];
        for (int i2 = 0; i2 < N; ++i2) {
            this.coeffs[i2] = ZERO;
        }
    }

    BigDecimalPolynomial(BigDecimal[] coeffs) {
        this.coeffs = coeffs;
    }

    public BigDecimalPolynomial(BigIntPolynomial p2) {
        int N = p2.coeffs.length;
        this.coeffs = new BigDecimal[N];
        for (int i2 = 0; i2 < N; ++i2) {
            this.coeffs[i2] = new BigDecimal(p2.coeffs[i2]);
        }
    }

    public void halve() {
        for (int i2 = 0; i2 < this.coeffs.length; ++i2) {
            this.coeffs[i2] = this.coeffs[i2].multiply(ONE_HALF);
        }
    }

    public BigDecimalPolynomial mult(BigIntPolynomial poly2) {
        return this.mult(new BigDecimalPolynomial(poly2));
    }

    public BigDecimalPolynomial mult(BigDecimalPolynomial poly2) {
        int N = this.coeffs.length;
        if (poly2.coeffs.length != N) {
            throw new IllegalArgumentException("Number of coefficients must be the same");
        }
        BigDecimalPolynomial c2 = this.multRecursive(poly2);
        if (c2.coeffs.length > N) {
            for (int k2 = N; k2 < c2.coeffs.length; ++k2) {
                c2.coeffs[k2 - N] = c2.coeffs[k2 - N].add(c2.coeffs[k2]);
            }
            c2.coeffs = this.copyOf(c2.coeffs, N);
        }
        return c2;
    }

    private BigDecimalPolynomial multRecursive(BigDecimalPolynomial poly2) {
        int i2;
        BigDecimal[] a2 = this.coeffs;
        BigDecimal[] b2 = poly2.coeffs;
        int n2 = poly2.coeffs.length;
        if (n2 <= 1) {
            BigDecimal[] c2 = (BigDecimal[])this.coeffs.clone();
            for (int i3 = 0; i3 < this.coeffs.length; ++i3) {
                c2[i3] = c2[i3].multiply(poly2.coeffs[0]);
            }
            return new BigDecimalPolynomial(c2);
        }
        int n1 = n2 / 2;
        BigDecimalPolynomial a1 = new BigDecimalPolynomial(this.copyOf(a2, n1));
        BigDecimalPolynomial a22 = new BigDecimalPolynomial(this.copyOfRange(a2, n1, n2));
        BigDecimalPolynomial b1 = new BigDecimalPolynomial(this.copyOf(b2, n1));
        BigDecimalPolynomial b22 = new BigDecimalPolynomial(this.copyOfRange(b2, n1, n2));
        BigDecimalPolynomial A = (BigDecimalPolynomial)a1.clone();
        A.add(a22);
        BigDecimalPolynomial B = (BigDecimalPolynomial)b1.clone();
        B.add(b22);
        BigDecimalPolynomial c1 = a1.multRecursive(b1);
        BigDecimalPolynomial c2 = a22.multRecursive(b22);
        BigDecimalPolynomial c3 = A.multRecursive(B);
        c3.sub(c1);
        c3.sub(c2);
        BigDecimalPolynomial c4 = new BigDecimalPolynomial(2 * n2 - 1);
        for (i2 = 0; i2 < c1.coeffs.length; ++i2) {
            c4.coeffs[i2] = c1.coeffs[i2];
        }
        for (i2 = 0; i2 < c3.coeffs.length; ++i2) {
            c4.coeffs[n1 + i2] = c4.coeffs[n1 + i2].add(c3.coeffs[i2]);
        }
        for (i2 = 0; i2 < c2.coeffs.length; ++i2) {
            c4.coeffs[2 * n1 + i2] = c4.coeffs[2 * n1 + i2].add(c2.coeffs[i2]);
        }
        return c4;
    }

    public void add(BigDecimalPolynomial b2) {
        if (b2.coeffs.length > this.coeffs.length) {
            int N = this.coeffs.length;
            this.coeffs = this.copyOf(this.coeffs, b2.coeffs.length);
            for (int i2 = N; i2 < this.coeffs.length; ++i2) {
                this.coeffs[i2] = ZERO;
            }
        }
        for (int i3 = 0; i3 < b2.coeffs.length; ++i3) {
            this.coeffs[i3] = this.coeffs[i3].add(b2.coeffs[i3]);
        }
    }

    void sub(BigDecimalPolynomial b2) {
        if (b2.coeffs.length > this.coeffs.length) {
            int N = this.coeffs.length;
            this.coeffs = this.copyOf(this.coeffs, b2.coeffs.length);
            for (int i2 = N; i2 < this.coeffs.length; ++i2) {
                this.coeffs[i2] = ZERO;
            }
        }
        for (int i3 = 0; i3 < b2.coeffs.length; ++i3) {
            this.coeffs[i3] = this.coeffs[i3].subtract(b2.coeffs[i3]);
        }
    }

    public BigIntPolynomial round() {
        int N = this.coeffs.length;
        BigIntPolynomial p2 = new BigIntPolynomial(N);
        for (int i2 = 0; i2 < N; ++i2) {
            p2.coeffs[i2] = this.coeffs[i2].setScale(0, 6).toBigInteger();
        }
        return p2;
    }

    public Object clone() {
        return new BigDecimalPolynomial((BigDecimal[])this.coeffs.clone());
    }

    private BigDecimal[] copyOf(BigDecimal[] a2, int length) {
        BigDecimal[] tmp = new BigDecimal[length];
        System.arraycopy(a2, 0, tmp, 0, a2.length < length ? a2.length : length);
        return tmp;
    }

    private BigDecimal[] copyOfRange(BigDecimal[] a2, int from, int to) {
        int newLength = to - from;
        BigDecimal[] tmp = new BigDecimal[newLength];
        System.arraycopy(a2, from, tmp, 0, a2.length - from < newLength ? a2.length - from : newLength);
        return tmp;
    }

    public BigDecimal[] getCoeffs() {
        BigDecimal[] tmp = new BigDecimal[this.coeffs.length];
        System.arraycopy(this.coeffs, 0, tmp, 0, this.coeffs.length);
        return tmp;
    }
}

