/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.eac;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.DERApplicationSpecific;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.eac.CertificateHolderAuthorization;
import com.timevale.tgtext.bouncycastle.asn1.eac.CertificateHolderReference;
import com.timevale.tgtext.bouncycastle.asn1.eac.CertificationAuthorityReference;
import com.timevale.tgtext.bouncycastle.asn1.eac.EACTags;
import com.timevale.tgtext.bouncycastle.asn1.eac.PackedDate;
import com.timevale.tgtext.bouncycastle.asn1.eac.PublicKeyDataObject;
import java.io.IOException;

public class CertificateBody
extends ASN1Object {
    ASN1InputStream seq;
    private DERApplicationSpecific certificateProfileIdentifier;
    private DERApplicationSpecific certificationAuthorityReference;
    private PublicKeyDataObject publicKey;
    private DERApplicationSpecific certificateHolderReference;
    private CertificateHolderAuthorization certificateHolderAuthorization;
    private DERApplicationSpecific certificateEffectiveDate;
    private DERApplicationSpecific certificateExpirationDate;
    private int certificateType = 0;
    private static final int CPI = 1;
    private static final int CAR = 2;
    private static final int PK = 4;
    private static final int CHR = 8;
    private static final int CHA = 16;
    private static final int CEfD = 32;
    private static final int CExD = 64;
    public static final int profileType = 127;
    public static final int requestType = 13;

    private void setIso7816CertificateBody(DERApplicationSpecific appSpe) throws IOException {
        ASN1Primitive obj;
        if (appSpe.getApplicationTag() != 78) {
            throw new IOException("Bad tag : not an iso7816 CERTIFICATE_CONTENT_TEMPLATE");
        }
        byte[] content = appSpe.getContents();
        ASN1InputStream aIS = new ASN1InputStream(content);
        block9: while ((obj = aIS.readObject()) != null) {
            if (!(obj instanceof DERApplicationSpecific)) {
                throw new IOException("Not a valid iso7816 content : not a DERApplicationSpecific Object :" + EACTags.encodeTag(appSpe) + obj.getClass());
            }
            DERApplicationSpecific aSpe = (DERApplicationSpecific)obj;
            switch (aSpe.getApplicationTag()) {
                case 41: {
                    this.setCertificateProfileIdentifier(aSpe);
                    continue block9;
                }
                case 2: {
                    this.setCertificationAuthorityReference(aSpe);
                    continue block9;
                }
                case 73: {
                    this.setPublicKey(PublicKeyDataObject.getInstance(aSpe.getObject(16)));
                    continue block9;
                }
                case 32: {
                    this.setCertificateHolderReference(aSpe);
                    continue block9;
                }
                case 76: {
                    this.setCertificateHolderAuthorization(new CertificateHolderAuthorization(aSpe));
                    continue block9;
                }
                case 37: {
                    this.setCertificateEffectiveDate(aSpe);
                    continue block9;
                }
                case 36: {
                    this.setCertificateExpirationDate(aSpe);
                    continue block9;
                }
            }
            this.certificateType = 0;
            throw new IOException("Not a valid iso7816 DERApplicationSpecific tag " + aSpe.getApplicationTag());
        }
    }

    public CertificateBody(DERApplicationSpecific certificateProfileIdentifier, CertificationAuthorityReference certificationAuthorityReference, PublicKeyDataObject publicKey, CertificateHolderReference certificateHolderReference, CertificateHolderAuthorization certificateHolderAuthorization, PackedDate certificateEffectiveDate, PackedDate certificateExpirationDate) {
        this.setCertificateProfileIdentifier(certificateProfileIdentifier);
        this.setCertificationAuthorityReference(new DERApplicationSpecific(2, certificationAuthorityReference.getEncoded()));
        this.setPublicKey(publicKey);
        this.setCertificateHolderReference(new DERApplicationSpecific(32, certificateHolderReference.getEncoded()));
        this.setCertificateHolderAuthorization(certificateHolderAuthorization);
        try {
            this.setCertificateEffectiveDate(new DERApplicationSpecific(false, 37, new DEROctetString(certificateEffectiveDate.getEncoding())));
            this.setCertificateExpirationDate(new DERApplicationSpecific(false, 36, new DEROctetString(certificateExpirationDate.getEncoding())));
            return;
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("unable to encode dates: " + e2.getMessage());
        }
    }

    private CertificateBody(DERApplicationSpecific obj) throws IOException {
        this.setIso7816CertificateBody(obj);
    }

    private ASN1Primitive profileToASN1Object() throws IOException {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.certificateProfileIdentifier);
        v2.add(this.certificationAuthorityReference);
        v2.add(new DERApplicationSpecific(false, 73, this.publicKey));
        v2.add(this.certificateHolderReference);
        v2.add(this.certificateHolderAuthorization);
        v2.add(this.certificateEffectiveDate);
        v2.add(this.certificateExpirationDate);
        return new DERApplicationSpecific(78, v2);
    }

    private void setCertificateProfileIdentifier(DERApplicationSpecific certificateProfileIdentifier) throws IllegalArgumentException {
        if (certificateProfileIdentifier.getApplicationTag() == 41) {
            this.certificateProfileIdentifier = certificateProfileIdentifier;
            this.certificateType |= 1;
            return;
        }
        throw new IllegalArgumentException("Not an Iso7816Tags.INTERCHANGE_PROFILE tag :" + EACTags.encodeTag(certificateProfileIdentifier));
    }

    private void setCertificateHolderReference(DERApplicationSpecific certificateHolderReference) throws IllegalArgumentException {
        if (certificateHolderReference.getApplicationTag() == 32) {
            this.certificateHolderReference = certificateHolderReference;
            this.certificateType |= 8;
            return;
        }
        throw new IllegalArgumentException("Not an Iso7816Tags.CARDHOLDER_NAME tag");
    }

    private void setCertificationAuthorityReference(DERApplicationSpecific certificationAuthorityReference) throws IllegalArgumentException {
        if (certificationAuthorityReference.getApplicationTag() == 2) {
            this.certificationAuthorityReference = certificationAuthorityReference;
            this.certificateType |= 2;
            return;
        }
        throw new IllegalArgumentException("Not an Iso7816Tags.ISSUER_IDENTIFICATION_NUMBER tag");
    }

    private void setPublicKey(PublicKeyDataObject publicKey) {
        this.publicKey = PublicKeyDataObject.getInstance(publicKey);
        this.certificateType |= 4;
    }

    private ASN1Primitive requestToASN1Object() throws IOException {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.certificateProfileIdentifier);
        v2.add(new DERApplicationSpecific(false, 73, this.publicKey));
        v2.add(this.certificateHolderReference);
        return new DERApplicationSpecific(78, v2);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        try {
            if (this.certificateType == 127) {
                return this.profileToASN1Object();
            }
            if (this.certificateType == 13) {
                return this.requestToASN1Object();
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return null;
    }

    public int getCertificateType() {
        return this.certificateType;
    }

    public static CertificateBody getInstance(Object obj) throws IOException {
        if (obj instanceof CertificateBody) {
            return (CertificateBody)obj;
        }
        if (obj != null) {
            return new CertificateBody(DERApplicationSpecific.getInstance(obj));
        }
        return null;
    }

    public PackedDate getCertificateEffectiveDate() {
        if ((this.certificateType & 0x20) == 32) {
            return new PackedDate(this.certificateEffectiveDate.getContents());
        }
        return null;
    }

    private void setCertificateEffectiveDate(DERApplicationSpecific ced) throws IllegalArgumentException {
        if (ced.getApplicationTag() == 37) {
            this.certificateEffectiveDate = ced;
            this.certificateType |= 0x20;
            return;
        }
        throw new IllegalArgumentException("Not an Iso7816Tags.APPLICATION_EFFECTIVE_DATE tag :" + EACTags.encodeTag(ced));
    }

    public PackedDate getCertificateExpirationDate() throws IOException {
        if ((this.certificateType & 0x40) == 64) {
            return new PackedDate(this.certificateExpirationDate.getContents());
        }
        throw new IOException("certificate Expiration Date not set");
    }

    private void setCertificateExpirationDate(DERApplicationSpecific ced) throws IllegalArgumentException {
        if (ced.getApplicationTag() == 36) {
            this.certificateExpirationDate = ced;
            this.certificateType |= 0x40;
            return;
        }
        throw new IllegalArgumentException("Not an Iso7816Tags.APPLICATION_EXPIRATION_DATE tag");
    }

    public CertificateHolderAuthorization getCertificateHolderAuthorization() throws IOException {
        if ((this.certificateType & 0x10) == 16) {
            return this.certificateHolderAuthorization;
        }
        throw new IOException("Certificate Holder Authorisation not set");
    }

    private void setCertificateHolderAuthorization(CertificateHolderAuthorization cha) {
        this.certificateHolderAuthorization = cha;
        this.certificateType |= 0x10;
    }

    public CertificateHolderReference getCertificateHolderReference() {
        return new CertificateHolderReference(this.certificateHolderReference.getContents());
    }

    public DERApplicationSpecific getCertificateProfileIdentifier() {
        return this.certificateProfileIdentifier;
    }

    public CertificationAuthorityReference getCertificationAuthorityReference() throws IOException {
        if ((this.certificateType & 2) == 2) {
            return new CertificationAuthorityReference(this.certificationAuthorityReference.getContents());
        }
        throw new IOException("Certification authority reference not set");
    }

    public PublicKeyDataObject getPublicKey() {
        return this.publicKey;
    }
}

