/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.cmp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIFreeText;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIStatusInfo;
import java.util.Enumeration;

public class ErrorMsgContent
extends ASN1Object {
    private PKIStatusInfo pkiStatusInfo;
    private ASN1Integer errorCode;
    private PKIFreeText errorDetails;

    private ErrorMsgContent(ASN1Sequence seq) {
        Enumeration en2 = seq.getObjects();
        this.pkiStatusInfo = PKIStatusInfo.getInstance(en2.nextElement());
        while (en2.hasMoreElements()) {
            Object o2 = en2.nextElement();
            if (o2 instanceof ASN1Integer) {
                this.errorCode = ASN1Integer.getInstance(o2);
                continue;
            }
            this.errorDetails = PKIFreeText.getInstance(o2);
        }
    }

    public static ErrorMsgContent getInstance(Object o2) {
        if (o2 instanceof ErrorMsgContent) {
            return (ErrorMsgContent)o2;
        }
        if (o2 != null) {
            return new ErrorMsgContent(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public ErrorMsgContent(PKIStatusInfo pkiStatusInfo) {
        this(pkiStatusInfo, null, null);
    }

    public ErrorMsgContent(PKIStatusInfo pkiStatusInfo, ASN1Integer errorCode, PKIFreeText errorDetails) {
        if (pkiStatusInfo == null) {
            throw new IllegalArgumentException("'pkiStatusInfo' cannot be null");
        }
        this.pkiStatusInfo = pkiStatusInfo;
        this.errorCode = errorCode;
        this.errorDetails = errorDetails;
    }

    public PKIStatusInfo getPKIStatusInfo() {
        return this.pkiStatusInfo;
    }

    public ASN1Integer getErrorCode() {
        return this.errorCode;
    }

    public PKIFreeText getErrorDetails() {
        return this.errorDetails;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.pkiStatusInfo);
        this.addOptional(v2, this.errorCode);
        this.addOptional(v2, this.errorDetails);
        return new DERSequence(v2);
    }

    private void addOptional(ASN1EncodableVector v2, ASN1Encodable obj) {
        if (obj != null) {
            v2.add(obj);
        }
    }
}

