/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.tsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;

public class Accuracy
extends ASN1Object {
    ASN1Integer seconds;
    ASN1Integer millis;
    ASN1Integer micros;
    protected static final int MIN_MILLIS = 1;
    protected static final int MAX_MILLIS = 999;
    protected static final int MIN_MICROS = 1;
    protected static final int MAX_MICROS = 999;

    protected Accuracy() {
    }

    public Accuracy(ASN1Integer seconds, ASN1Integer millis, ASN1Integer micros) {
        this.seconds = seconds;
        if (millis != null && (millis.getValue().intValue() <= 0 || millis.getValue().intValue() > 999)) {
            throw new IllegalArgumentException("Invalid millis field : not in (1..999)");
        }
        this.millis = millis;
        if (micros != null && (micros.getValue().intValue() <= 0 || micros.getValue().intValue() > 999)) {
            throw new IllegalArgumentException("Invalid micros field : not in (1..999)");
        }
        this.micros = micros;
    }

    private Accuracy(ASN1Sequence seq) {
        this.seconds = null;
        this.millis = null;
        this.micros = null;
        block4: for (int i2 = 0; i2 < seq.size(); ++i2) {
            if (seq.getObjectAt(i2) instanceof ASN1Integer) {
                this.seconds = (ASN1Integer)seq.getObjectAt(i2);
                continue;
            }
            if (!(seq.getObjectAt(i2) instanceof DERTaggedObject)) continue;
            DERTaggedObject extra = (DERTaggedObject)seq.getObjectAt(i2);
            switch (extra.getTagNo()) {
                case 0: {
                    this.millis = ASN1Integer.getInstance(extra, false);
                    if (this.millis.getValue().intValue() > 0 && this.millis.getValue().intValue() <= 999) continue block4;
                    throw new IllegalArgumentException("Invalid millis field : not in (1..999).");
                }
                case 1: {
                    this.micros = ASN1Integer.getInstance(extra, false);
                    if (this.micros.getValue().intValue() > 0 && this.micros.getValue().intValue() <= 999) continue block4;
                    throw new IllegalArgumentException("Invalid micros field : not in (1..999).");
                }
                default: {
                    throw new IllegalArgumentException("Invalig tag number");
                }
            }
        }
    }

    public static Accuracy getInstance(Object o2) {
        if (o2 instanceof Accuracy) {
            return (Accuracy)o2;
        }
        if (o2 != null) {
            return new Accuracy(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public ASN1Integer getSeconds() {
        return this.seconds;
    }

    public ASN1Integer getMillis() {
        return this.millis;
    }

    public ASN1Integer getMicros() {
        return this.micros;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        if (this.seconds != null) {
            v2.add(this.seconds);
        }
        if (this.millis != null) {
            v2.add(new DERTaggedObject(false, 0, this.millis));
        }
        if (this.micros != null) {
            v2.add(new DERTaggedObject(false, 1, this.micros));
        }
        return new DERSequence(v2);
    }
}

