/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.gmss;

import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import com.timevale.tgtext.bouncycastle.util.encoders.Hex;

public class GMSSLeaf {
    private Digest messDigestOTS;
    private int mdsize;
    private int keysize;
    private GMSSRandom gmssRandom;
    private byte[] leaf;
    private byte[] concHashs;
    private int i;
    private int j;
    private int two_power_w;
    private int w;
    private int steps;
    private byte[] seed;
    byte[] privateKeyOTS;

    public GMSSLeaf(Digest digest, byte[][] otsIndex, int[] numLeafs) {
        this.i = numLeafs[0];
        this.j = numLeafs[1];
        this.steps = numLeafs[2];
        this.w = numLeafs[3];
        this.messDigestOTS = digest;
        this.gmssRandom = new GMSSRandom(this.messDigestOTS);
        this.mdsize = this.messDigestOTS.getDigestSize();
        int mdsizeBit = this.mdsize << 3;
        int messagesize = (int)Math.ceil((double)mdsizeBit / (double)this.w);
        int checksumsize = this.getLog((messagesize << this.w) + 1);
        this.keysize = messagesize + (int)Math.ceil((double)checksumsize / (double)this.w);
        this.two_power_w = 1 << this.w;
        this.privateKeyOTS = otsIndex[0];
        this.seed = otsIndex[1];
        this.concHashs = otsIndex[2];
        this.leaf = otsIndex[3];
    }

    public GMSSLeaf(Digest digest, int w2, int numLeafs) {
        this.w = w2;
        this.messDigestOTS = digest;
        this.gmssRandom = new GMSSRandom(this.messDigestOTS);
        this.mdsize = this.messDigestOTS.getDigestSize();
        int mdsizeBit = this.mdsize << 3;
        int messagesize = (int)Math.ceil((double)mdsizeBit / (double)w2);
        int checksumsize = this.getLog((messagesize << w2) + 1);
        this.keysize = messagesize + (int)Math.ceil((double)checksumsize / (double)w2);
        this.two_power_w = 1 << w2;
        this.steps = (int)Math.ceil((double)(((1 << w2) - 1) * this.keysize + 1 + this.keysize) / (double)numLeafs);
        this.seed = new byte[this.mdsize];
        this.leaf = new byte[this.mdsize];
        this.privateKeyOTS = new byte[this.mdsize];
        this.concHashs = new byte[this.mdsize * this.keysize];
    }

    public void initLeafCalc(byte[] seed0) {
        this.i = 0;
        this.j = 0;
        byte[] dummy = new byte[this.mdsize];
        System.arraycopy(seed0, 0, dummy, 0, this.seed.length);
        this.seed = this.gmssRandom.nextSeed(dummy);
    }

    public boolean updateLeafCalc() {
        for (int s2 = 0; s2 < this.steps; ++s2) {
            if (this.i == this.keysize && this.j == this.two_power_w - 1) {
                this.messDigestOTS.update(this.concHashs, 0, this.concHashs.length);
                this.leaf = new byte[this.messDigestOTS.getDigestSize()];
                this.messDigestOTS.doFinal(this.leaf, 0);
                return true;
            }
            if (this.i == 0 || this.j == this.two_power_w - 1) {
                ++this.i;
                this.j = 0;
                this.privateKeyOTS = this.gmssRandom.nextSeed(this.seed);
                continue;
            }
            this.messDigestOTS.update(this.privateKeyOTS, 0, this.privateKeyOTS.length);
            this.privateKeyOTS = new byte[this.messDigestOTS.getDigestSize()];
            this.messDigestOTS.doFinal(this.privateKeyOTS, 0);
            ++this.j;
            if (this.j != this.two_power_w - 1) continue;
            System.arraycopy(this.privateKeyOTS, 0, this.concHashs, this.mdsize * (this.i - 1), this.mdsize);
        }
        return false;
    }

    public byte[] getLeaf() {
        return Arrays.clone(this.leaf);
    }

    private int getLog(int intValue) {
        int log = 1;
        int i2 = 2;
        while (i2 < intValue) {
            i2 <<= 1;
            ++log;
        }
        return log;
    }

    public byte[][] getStatByte() {
        byte[][] byArrayArray = new byte[4][];
        byte[][] statByte = byArrayArray;
        byArrayArray[0] = new byte[this.mdsize];
        statByte[1] = new byte[this.mdsize];
        statByte[2] = new byte[this.mdsize * this.keysize];
        statByte[3] = new byte[this.mdsize];
        statByte[0] = this.privateKeyOTS;
        statByte[1] = this.seed;
        statByte[2] = this.concHashs;
        statByte[3] = this.leaf;
        return statByte;
    }

    public int[] getStatInt() {
        int[] nArray = new int[4];
        int[] statInt = nArray;
        nArray[0] = this.i;
        statInt[1] = this.j;
        statInt[2] = this.steps;
        statInt[3] = this.w;
        return statInt;
    }

    public String toString() {
        String out = "";
        for (int i2 = 0; i2 < 4; ++i2) {
            out = out + this.getStatInt()[i2] + " ";
        }
        out = out + " " + this.mdsize + " " + this.keysize + " " + this.two_power_w + " ";
        byte[][] temp = this.getStatByte();
        for (int i3 = 0; i3 < 4; ++i3) {
            out = temp[i3] != null ? out + new String(Hex.encode(temp[i3])) + " " : out + "null ";
        }
        return out;
    }
}

