/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.cmp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;

public class InfoTypeAndValue
extends ASN1Object {
    private ASN1ObjectIdentifier infoType;
    private ASN1Encodable infoValue;

    private InfoTypeAndValue(ASN1Sequence seq) {
        this.infoType = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0));
        if (seq.size() > 1) {
            this.infoValue = seq.getObjectAt(1);
        }
    }

    public static InfoTypeAndValue getInstance(Object o2) {
        if (o2 instanceof InfoTypeAndValue) {
            return (InfoTypeAndValue)o2;
        }
        if (o2 != null) {
            return new InfoTypeAndValue(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public InfoTypeAndValue(ASN1ObjectIdentifier infoType) {
        this.infoType = infoType;
        this.infoValue = null;
    }

    public InfoTypeAndValue(ASN1ObjectIdentifier infoType, ASN1Encodable optionalValue) {
        this.infoType = infoType;
        this.infoValue = optionalValue;
    }

    public ASN1ObjectIdentifier getInfoType() {
        return this.infoType;
    }

    public ASN1Encodable getInfoValue() {
        return this.infoValue;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.infoType);
        if (this.infoValue != null) {
            v2.add(this.infoValue);
        }
        return new DERSequence(v2);
    }
}

