/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.BigIntUtils;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import java.math.BigInteger;

final class a {
    private static final BigInteger a = BigInteger.valueOf(0L);
    private static final BigInteger b = BigInteger.valueOf(1L);

    private a() {
    }

    public static GF2Vector a(int n2, int t2, byte[] m2) {
        if (n2 < t2) {
            throw new IllegalArgumentException("n < t");
        }
        BigInteger i2 = new BigInteger(1, m2);
        BigInteger c2 = IntegerFunctions.binomial(n2, t2);
        if (i2.compareTo(c2) >= 0) {
            throw new IllegalArgumentException("Encoded number too large.");
        }
        GF2Vector result = new GF2Vector(n2);
        int nn = n2;
        int tt = t2;
        for (int j2 = 0; j2 < n2; ++j2) {
            c2 = c2.multiply(BigInteger.valueOf(nn - tt)).divide(BigInteger.valueOf(nn));
            --nn;
            if (c2.compareTo(i2) > 0) continue;
            result.setBit(j2);
            i2 = i2.subtract(c2);
            c2 = nn == --tt ? b : c2.multiply(BigInteger.valueOf(tt + 1)).divide(BigInteger.valueOf(nn - tt));
        }
        return result;
    }

    public static byte[] a(int n2, int t2, GF2Vector vec) {
        if (vec.getLength() != n2 || vec.getHammingWeight() != t2) {
            throw new IllegalArgumentException("vector has wrong length or hamming weight");
        }
        int[] vecArray = vec.getVecArray();
        BigInteger bc2 = IntegerFunctions.binomial(n2, t2);
        BigInteger d2 = a;
        int nn = n2;
        int tt = t2;
        for (int i2 = 0; i2 < n2; ++i2) {
            bc2 = bc2.multiply(BigInteger.valueOf(nn - tt)).divide(BigInteger.valueOf(nn));
            --nn;
            int q2 = i2 >> 5;
            int e2 = vecArray[q2] & 1 << (i2 & 0x1F);
            if (e2 == 0) continue;
            d2 = d2.add(bc2);
            bc2 = nn == --tt ? b : bc2.multiply(BigInteger.valueOf(tt + 1)).divide(BigInteger.valueOf(nn - tt));
        }
        return BigIntUtils.toMinimalByteArray(d2);
    }

    public static byte[] b(int n2, int t2, byte[] m2) {
        byte[] data;
        if (n2 < t2) {
            throw new IllegalArgumentException("n < t");
        }
        BigInteger bc2 = IntegerFunctions.binomial(n2, t2);
        int s2 = bc2.bitLength() - 1;
        int sq = s2 >> 3;
        int sr = s2 & 7;
        if (sr == 0) {
            --sq;
            sr = 8;
        }
        int nq = n2 >> 3;
        int nr = n2 & 7;
        if (nr == 0) {
            --nq;
            nr = 8;
        }
        if (m2.length < (data = new byte[nq + 1]).length) {
            System.arraycopy(m2, 0, data, 0, m2.length);
            for (int i2 = m2.length; i2 < data.length; ++i2) {
                data[i2] = 0;
            }
        } else {
            System.arraycopy(m2, 0, data, 0, nq);
            int h2 = (1 << nr) - 1;
            data[nq] = (byte)(h2 & m2[nq]);
        }
        BigInteger d2 = a;
        int nn = n2;
        int tt = t2;
        for (int i3 = 0; i3 < n2; ++i3) {
            bc2 = bc2.multiply(new BigInteger(Integer.toString(nn - tt))).divide(new BigInteger(Integer.toString(nn)));
            --nn;
            int q2 = i3 >>> 3;
            int r2 = i3 & 7;
            byte e2 = (byte)((r2 = 1 << r2) & data[q2]);
            if (e2 == 0) continue;
            d2 = d2.add(bc2);
            bc2 = nn == --tt ? b : bc2.multiply(new BigInteger(Integer.toString(tt + 1))).divide(new BigInteger(Integer.toString(nn - tt)));
        }
        byte[] result = new byte[sq + 1];
        byte[] help = d2.toByteArray();
        if (help.length < result.length) {
            System.arraycopy(help, 0, result, 0, help.length);
            for (int i4 = help.length; i4 < result.length; ++i4) {
                result[i4] = 0;
            }
        } else {
            System.arraycopy(help, 0, result, 0, sq);
            result[sq] = (byte)((1 << sr) - 1 & help[sq]);
        }
        return result;
    }
}

