/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.x500.X500Name;
import com.timevale.tgtext.bouncycastle.crypto.prng.ThreadedSeedGenerator;
import com.timevale.tgtext.bouncycastle.crypto.tls.ByteQueue;
import com.timevale.tgtext.bouncycastle.crypto.tls.Certificate;
import com.timevale.tgtext.bouncycastle.crypto.tls.CertificateRequest;
import com.timevale.tgtext.bouncycastle.crypto.tls.CertificateVerifyer;
import com.timevale.tgtext.bouncycastle.crypto.tls.LegacyTlsClient;
import com.timevale.tgtext.bouncycastle.crypto.tls.ProtocolVersion;
import com.timevale.tgtext.bouncycastle.crypto.tls.SecurityParameters;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsAuthentication;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsClient;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsCredentials;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsKeyExchange;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsSignerCredentials;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsUtils;
import com.timevale.tgtext.bouncycastle.crypto.tls.b;
import com.timevale.tgtext.bouncycastle.crypto.tls.c;
import com.timevale.tgtext.bouncycastle.crypto.tls.k;
import com.timevale.tgtext.bouncycastle.crypto.tls.l;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import com.timevale.tgtext.bouncycastle.util.Integers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TlsProtocolHandler {
    private static final Integer EXT_RenegotiationInfo = Integers.valueOf(65281);
    private static final short CS_CLIENT_HELLO_SEND = 1;
    private static final short CS_SERVER_HELLO_RECEIVED = 2;
    private static final short CS_SERVER_CERTIFICATE_RECEIVED = 3;
    private static final short CS_SERVER_KEY_EXCHANGE_RECEIVED = 4;
    private static final short CS_CERTIFICATE_REQUEST_RECEIVED = 5;
    private static final short CS_SERVER_HELLO_DONE_RECEIVED = 6;
    private static final short CS_CLIENT_KEY_EXCHANGE_SEND = 7;
    private static final short CS_CERTIFICATE_VERIFY_SEND = 8;
    private static final short CS_CLIENT_CHANGE_CIPHER_SPEC_SEND = 9;
    private static final short CS_CLIENT_FINISHED_SEND = 10;
    private static final short CS_SERVER_CHANGE_CIPHER_SPEC_RECEIVED = 11;
    private static final short CS_DONE = 12;
    private static final byte[] emptybuf = new byte[0];
    private static final String TLS_ERROR_MESSAGE = "Internal TLS error, this could be an attack";
    private ByteQueue applicationDataQueue = new ByteQueue();
    private ByteQueue changeCipherSpecQueue = new ByteQueue();
    private ByteQueue alertQueue = new ByteQueue();
    private ByteQueue handshakeQueue = new ByteQueue();
    private b rs;
    private SecureRandom random;
    private k tlsInputStream = null;
    private l tlsOutputStream = null;
    private boolean closed = false;
    private boolean failedWithError = false;
    private boolean appDataReady = false;
    private Hashtable clientExtensions;
    private SecurityParameters securityParameters = null;
    private c tlsClientContext = null;
    private TlsClient tlsClient = null;
    private int[] offeredCipherSuites = null;
    private short[] offeredCompressionMethods = null;
    private TlsKeyExchange keyExchange = null;
    private TlsAuthentication authentication = null;
    private CertificateRequest certificateRequest = null;
    private short connection_state = 0;

    private static SecureRandom createSecureRandom() {
        ThreadedSeedGenerator tsg = new ThreadedSeedGenerator();
        SecureRandom random = new SecureRandom();
        random.setSeed(tsg.generateSeed(20, true));
        return random;
    }

    public TlsProtocolHandler(InputStream is, OutputStream os) {
        this(is, os, TlsProtocolHandler.createSecureRandom());
    }

    public TlsProtocolHandler(InputStream is, OutputStream os, SecureRandom sr) {
        this.rs = new b(this, is, os);
        this.random = sr;
    }

    protected void processData(short protocol, byte[] buf, int offset, int len) throws IOException {
        switch (protocol) {
            case 20: {
                this.changeCipherSpecQueue.addData(buf, offset, len);
                this.processChangeCipherSpec();
                return;
            }
            case 21: {
                this.alertQueue.addData(buf, offset, len);
                this.processAlert();
                return;
            }
            case 22: {
                this.handshakeQueue.addData(buf, offset, len);
                this.processHandshake();
                return;
            }
            case 23: {
                if (!this.appDataReady) {
                    this.failWithError((short)2, (short)10);
                }
                this.applicationDataQueue.addData(buf, offset, len);
                this.processApplicationData();
            }
        }
    }

    private void processHandshake() throws IOException {
        boolean read;
        do {
            read = false;
            if (this.handshakeQueue.size() < 4) continue;
            byte[] beginning = new byte[4];
            this.handshakeQueue.read(beginning, 0, 4, 0);
            ByteArrayInputStream bis = new ByteArrayInputStream(beginning);
            short type = TlsUtils.readUint8(bis);
            int len = TlsUtils.readUint24(bis);
            if (this.handshakeQueue.size() < len + 4) continue;
            byte[] buf = new byte[len];
            this.handshakeQueue.read(buf, 0, len, 4);
            this.handshakeQueue.removeData(len + 4);
            switch (type) {
                case 0: 
                case 20: {
                    break;
                }
                default: {
                    this.rs.a(beginning, 0, 4);
                    this.rs.a(buf, 0, len);
                }
            }
            this.processHandshakeMessage(type, buf);
            read = true;
        } while (read);
    }

    private void processHandshakeMessage(short type, byte[] buf) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        switch (type) {
            case 11: {
                switch (this.connection_state) {
                    case 2: {
                        Certificate serverCertificate = Certificate.parse(is);
                        this.assertEmpty(is);
                        this.keyExchange.processServerCertificate(serverCertificate);
                        this.authentication = this.tlsClient.getAuthentication();
                        this.authentication.notifyServerCertificate(serverCertificate);
                        break;
                    }
                    default: {
                        this.failWithError((short)2, (short)10);
                    }
                }
                this.connection_state = (short)3;
                return;
            }
            case 20: {
                switch (this.connection_state) {
                    case 11: {
                        boolean isTls = this.tlsClientContext.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
                        int checksumLength = isTls ? 12 : 36;
                        byte[] serverVerifyData = new byte[checksumLength];
                        TlsUtils.readFully(serverVerifyData, is);
                        this.assertEmpty(is);
                        byte[] expectedServerVerifyData = TlsUtils.calculateVerifyData(this.tlsClientContext, "server finished", this.rs.a(TlsUtils.SSL_SERVER));
                        if (!Arrays.constantTimeAreEqual(expectedServerVerifyData, serverVerifyData)) {
                            this.failWithError((short)2, (short)40);
                        }
                        this.connection_state = (short)12;
                        this.appDataReady = true;
                        return;
                    }
                }
                this.failWithError((short)2, (short)10);
                return;
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        byte[] renegExtValue;
                        ProtocolVersion server_version = TlsUtils.readVersion(is);
                        ProtocolVersion client_version = this.tlsClientContext.getClientVersion();
                        if (server_version.getFullVersion() > client_version.getFullVersion()) {
                            this.failWithError((short)2, (short)47);
                        }
                        this.tlsClientContext.b(server_version);
                        this.tlsClient.notifyServerVersion(server_version);
                        this.securityParameters.serverRandom = new byte[32];
                        TlsUtils.readFully(this.securityParameters.serverRandom, is);
                        byte[] sessionID = TlsUtils.readOpaque8(is);
                        if (sessionID.length > 32) {
                            this.failWithError((short)2, (short)47);
                        }
                        this.tlsClient.notifySessionID(sessionID);
                        int selectedCipherSuite = TlsUtils.readUint16(is);
                        if (!TlsProtocolHandler.arrayContains(this.offeredCipherSuites, selectedCipherSuite) || selectedCipherSuite == 255) {
                            this.failWithError((short)2, (short)47);
                        }
                        this.tlsClient.notifySelectedCipherSuite(selectedCipherSuite);
                        short selectedCompressionMethod = TlsUtils.readUint8(is);
                        if (!TlsProtocolHandler.arrayContains(this.offeredCompressionMethods, selectedCompressionMethod)) {
                            this.failWithError((short)2, (short)47);
                        }
                        this.tlsClient.notifySelectedCompressionMethod(selectedCompressionMethod);
                        Hashtable<Integer, byte[]> serverExtensions = new Hashtable<Integer, byte[]>();
                        if (is.available() > 0) {
                            byte[] extBytes = TlsUtils.readOpaque16(is);
                            ByteArrayInputStream ext = new ByteArrayInputStream(extBytes);
                            while (ext.available() > 0) {
                                Integer extType = Integers.valueOf(TlsUtils.readUint16(ext));
                                byte[] extValue = TlsUtils.readOpaque16(ext);
                                if (!extType.equals(EXT_RenegotiationInfo) && this.clientExtensions.get(extType) == null) {
                                    this.failWithError((short)2, (short)110);
                                }
                                if (serverExtensions.containsKey(extType)) {
                                    this.failWithError((short)2, (short)47);
                                }
                                serverExtensions.put(extType, extValue);
                            }
                        }
                        this.assertEmpty(is);
                        boolean secure_negotiation = serverExtensions.containsKey(EXT_RenegotiationInfo);
                        if (secure_negotiation && !Arrays.constantTimeAreEqual(renegExtValue = (byte[])serverExtensions.get(EXT_RenegotiationInfo), TlsProtocolHandler.createRenegotiationInfo(emptybuf))) {
                            this.failWithError((short)2, (short)40);
                        }
                        this.tlsClient.notifySecureRenegotiation(secure_negotiation);
                        if (this.clientExtensions != null) {
                            this.tlsClient.processServerExtensions(serverExtensions);
                        }
                        this.keyExchange = this.tlsClient.getKeyExchange();
                        this.connection_state = (short)2;
                        return;
                    }
                }
                this.failWithError((short)2, (short)10);
                return;
            }
            case 14: {
                switch (this.connection_state) {
                    case 2: {
                        this.keyExchange.skipServerCertificate();
                        this.authentication = null;
                    }
                    case 3: {
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 4: 
                    case 5: {
                        this.assertEmpty(is);
                        this.connection_state = (short)6;
                        TlsCredentials clientCreds = null;
                        if (this.certificateRequest == null) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            clientCreds = this.authentication.getClientCredentials(this.certificateRequest);
                            if (clientCreds == null) {
                                this.keyExchange.skipClientCredentials();
                                boolean isTls = this.tlsClientContext.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
                                if (isTls) {
                                    this.sendClientCertificate(Certificate.EMPTY_CHAIN);
                                } else {
                                    this.sendAlert((short)1, (short)41);
                                }
                            } else {
                                this.keyExchange.processClientCredentials(clientCreds);
                                this.sendClientCertificate(clientCreds.getCertificate());
                            }
                        }
                        this.sendClientKeyExchange();
                        this.connection_state = (short)7;
                        byte[] pms = this.keyExchange.generatePremasterSecret();
                        this.securityParameters.masterSecret = TlsUtils.calculateMasterSecret(this.tlsClientContext, pms);
                        Arrays.fill(pms, (byte)0);
                        if (clientCreds != null && clientCreds instanceof TlsSignerCredentials) {
                            TlsSignerCredentials signerCreds = (TlsSignerCredentials)clientCreds;
                            byte[] md5andsha1 = this.rs.a((byte[])null);
                            byte[] clientCertificateSignature = signerCreds.generateCertificateSignature(md5andsha1);
                            this.sendCertificateVerify(clientCertificateSignature);
                            this.connection_state = (short)8;
                        }
                        byte[] byArray = new byte[1];
                        byte[] cmessage = byArray;
                        byArray[0] = 1;
                        this.rs.a((short)20, cmessage, 0, 1);
                        this.connection_state = (short)9;
                        this.rs.a(this.tlsClient.getCompression(), this.tlsClient.getCipher());
                        byte[] clientVerifyData = TlsUtils.calculateVerifyData(this.tlsClientContext, "client finished", this.rs.a(TlsUtils.SSL_CLIENT));
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        TlsUtils.writeUint8((short)20, bos);
                        TlsUtils.writeOpaque24(clientVerifyData, bos);
                        byte[] message = bos.toByteArray();
                        this.rs.a((short)22, message, 0, message.length);
                        this.connection_state = (short)10;
                        return;
                    }
                }
                this.failWithError((short)2, (short)40);
                return;
            }
            case 12: {
                switch (this.connection_state) {
                    case 2: {
                        this.keyExchange.skipServerCertificate();
                        this.authentication = null;
                    }
                    case 3: {
                        this.keyExchange.processServerKeyExchange(is);
                        this.assertEmpty(is);
                        break;
                    }
                    default: {
                        this.failWithError((short)2, (short)10);
                    }
                }
                this.connection_state = (short)4;
                return;
            }
            case 13: {
                switch (this.connection_state) {
                    case 3: {
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 4: {
                        if (this.authentication == null) {
                            this.failWithError((short)2, (short)40);
                        }
                        int numTypes = TlsUtils.readUint8(is);
                        short[] certificateTypes = new short[numTypes];
                        for (int i2 = 0; i2 < numTypes; ++i2) {
                            certificateTypes[i2] = TlsUtils.readUint8(is);
                        }
                        byte[] authorities = TlsUtils.readOpaque16(is);
                        this.assertEmpty(is);
                        Vector<X500Name> authorityDNs = new Vector<X500Name>();
                        ByteArrayInputStream bis = new ByteArrayInputStream(authorities);
                        while (bis.available() > 0) {
                            byte[] dnBytes = TlsUtils.readOpaque16(bis);
                            authorityDNs.addElement(X500Name.getInstance(ASN1Primitive.fromByteArray(dnBytes)));
                        }
                        this.certificateRequest = new CertificateRequest(certificateTypes, authorityDNs);
                        this.keyExchange.validateCertificateRequest(this.certificateRequest);
                        break;
                    }
                    default: {
                        this.failWithError((short)2, (short)10);
                    }
                }
                this.connection_state = (short)5;
                return;
            }
            case 0: {
                if (this.connection_state != 12) break;
                this.sendAlert((short)1, (short)100);
                return;
            }
            default: {
                this.failWithError((short)2, (short)10);
            }
        }
    }

    private void processApplicationData() {
    }

    private void processAlert() throws IOException {
        while (this.alertQueue.size() >= 2) {
            byte[] tmp = new byte[2];
            this.alertQueue.read(tmp, 0, 2, 0);
            this.alertQueue.removeData(2);
            short level = tmp[0];
            short description = tmp[1];
            if (level == 2) {
                this.failedWithError = true;
                this.closed = true;
                try {
                    this.rs.c();
                }
                catch (Exception exception) {}
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            if (description != 0) continue;
            this.failWithError((short)1, (short)0);
        }
    }

    private void processChangeCipherSpec() throws IOException {
        while (this.changeCipherSpecQueue.size() > 0) {
            byte[] b2 = new byte[1];
            this.changeCipherSpecQueue.read(b2, 0, 1, 0);
            this.changeCipherSpecQueue.removeData(1);
            if (b2[0] != 1) {
                this.failWithError((short)2, (short)10);
            }
            if (this.connection_state != 10) {
                this.failWithError((short)2, (short)40);
            }
            this.rs.a();
            this.connection_state = (short)11;
        }
    }

    private void sendClientCertificate(Certificate clientCert) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)11, bos);
        TlsUtils.writeUint24(0, bos);
        clientCert.encode(bos);
        byte[] message = bos.toByteArray();
        TlsUtils.writeUint24(message.length - 4, message, 1);
        this.rs.a((short)22, message, 0, message.length);
    }

    private void sendClientKeyExchange() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)16, bos);
        TlsUtils.writeUint24(0, bos);
        this.keyExchange.generateClientKeyExchange(bos);
        byte[] message = bos.toByteArray();
        TlsUtils.writeUint24(message.length - 4, message, 1);
        this.rs.a((short)22, message, 0, message.length);
    }

    private void sendCertificateVerify(byte[] data) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)15, bos);
        TlsUtils.writeUint24(data.length + 2, bos);
        TlsUtils.writeOpaque16(data, bos);
        byte[] message = bos.toByteArray();
        this.rs.a((short)22, message, 0, message.length);
    }

    public void connect(CertificateVerifyer verifyer) throws IOException {
        this.connect(new LegacyTlsClient(verifyer));
    }

    public void connect(TlsClient tlsClient) throws IOException {
        if (tlsClient == null) {
            throw new IllegalArgumentException("'tlsClient' cannot be null");
        }
        if (this.tlsClient != null) {
            throw new IllegalStateException("connect can only be called once");
        }
        this.securityParameters = new SecurityParameters();
        this.securityParameters.clientRandom = new byte[32];
        this.random.nextBytes(this.securityParameters.clientRandom);
        TlsUtils.writeGMTUnixTime(this.securityParameters.clientRandom, 0);
        this.tlsClientContext = new c(this.random, this.securityParameters);
        this.rs.a(this.tlsClientContext);
        this.tlsClient = tlsClient;
        this.tlsClient.init(this.tlsClientContext);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ProtocolVersion client_version = this.tlsClient.getClientVersion();
        this.tlsClientContext.a(client_version);
        this.tlsClientContext.b(client_version);
        TlsUtils.writeVersion(client_version, os);
        os.write(this.securityParameters.clientRandom);
        TlsUtils.writeUint8((short)0, os);
        this.offeredCipherSuites = this.tlsClient.getCipherSuites();
        this.clientExtensions = this.tlsClient.getClientExtensions();
        boolean noRenegExt = this.clientExtensions == null || this.clientExtensions.get(EXT_RenegotiationInfo) == null;
        int count = this.offeredCipherSuites.length;
        if (noRenegExt) {
            ++count;
        }
        TlsUtils.writeUint16(2 * count, os);
        TlsUtils.writeUint16Array(this.offeredCipherSuites, os);
        if (noRenegExt) {
            TlsUtils.writeUint16(255, os);
        }
        this.offeredCompressionMethods = this.tlsClient.getCompressionMethods();
        TlsUtils.writeUint8((short)this.offeredCompressionMethods.length, os);
        TlsUtils.writeUint8Array(this.offeredCompressionMethods, os);
        if (this.clientExtensions != null) {
            ByteArrayOutputStream ext = new ByteArrayOutputStream();
            Enumeration keys = this.clientExtensions.keys();
            while (keys.hasMoreElements()) {
                Integer extType = (Integer)keys.nextElement();
                TlsProtocolHandler.writeExtension(ext, extType, (byte[])this.clientExtensions.get(extType));
            }
            TlsUtils.writeOpaque16(ext.toByteArray(), os);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)1, bos);
        TlsUtils.writeUint24(os.size(), bos);
        bos.write(os.toByteArray());
        byte[] message = bos.toByteArray();
        this.safeWriteMessage((short)22, message, 0, message.length);
        this.connection_state = 1;
        while (this.connection_state != 12) {
            this.safeReadData();
        }
        this.tlsInputStream = new k(this);
        this.tlsOutputStream = new l(this);
    }

    protected int readApplicationData(byte[] buf, int offset, int len) throws IOException {
        while (this.applicationDataQueue.size() == 0) {
            if (this.closed) {
                if (this.failedWithError) {
                    throw new IOException(TLS_ERROR_MESSAGE);
                }
                return -1;
            }
            this.safeReadData();
        }
        len = Math.min(len, this.applicationDataQueue.size());
        this.applicationDataQueue.read(buf, offset, len, 0);
        this.applicationDataQueue.removeData(len);
        return len;
    }

    private void safeReadData() throws IOException {
        try {
            this.rs.b();
            return;
        }
        catch (TlsFatalAlert e2) {
            if (!this.closed) {
                this.failWithError((short)2, e2.getAlertDescription());
            }
            throw e2;
        }
        catch (IOException e3) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80);
            }
            throw e3;
        }
        catch (RuntimeException e4) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80);
            }
            throw e4;
        }
    }

    private void safeWriteMessage(short type, byte[] buf, int offset, int len) throws IOException {
        try {
            this.rs.a(type, buf, offset, len);
            return;
        }
        catch (TlsFatalAlert e2) {
            if (!this.closed) {
                this.failWithError((short)2, e2.getAlertDescription());
            }
            throw e2;
        }
        catch (IOException e3) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80);
            }
            throw e3;
        }
        catch (RuntimeException e4) {
            if (!this.closed) {
                this.failWithError((short)2, (short)80);
            }
            throw e4;
        }
    }

    protected void writeData(byte[] buf, int offset, int len) throws IOException {
        int toWrite;
        if (this.closed) {
            if (this.failedWithError) {
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            throw new IOException("Sorry, connection has been closed, you cannot write more data");
        }
        this.safeWriteMessage((short)23, emptybuf, 0, 0);
        do {
            toWrite = Math.min(len, 16384);
            this.safeWriteMessage((short)23, buf, offset, toWrite);
            offset += toWrite;
        } while ((len -= toWrite) > 0);
    }

    public OutputStream getOutputStream() {
        return this.tlsOutputStream;
    }

    public InputStream getInputStream() {
        return this.tlsInputStream;
    }

    private void failWithError(short alertLevel, short alertDescription) throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (alertLevel == 2) {
                this.failedWithError = true;
            }
            this.sendAlert(alertLevel, alertDescription);
            this.rs.c();
            if (alertLevel == 2) {
                throw new IOException(TLS_ERROR_MESSAGE);
            }
        } else {
            throw new IOException(TLS_ERROR_MESSAGE);
        }
    }

    private void sendAlert(short alertLevel, short alertDescription) throws IOException {
        byte[] byArray = new byte[2];
        byte[] error = byArray;
        byArray[0] = (byte)alertLevel;
        error[1] = (byte)alertDescription;
        this.rs.a((short)21, error, 0, 2);
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.failWithError((short)1, (short)0);
        }
    }

    protected void assertEmpty(ByteArrayInputStream is) throws IOException {
        if (is.available() > 0) {
            throw new TlsFatalAlert(50);
        }
    }

    protected void flush() throws IOException {
        this.rs.d();
    }

    private static boolean arrayContains(short[] a2, short n2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            if (a2[i2] != n2) continue;
            return true;
        }
        return false;
    }

    private static boolean arrayContains(int[] a2, int n2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            if (a2[i2] != n2) continue;
            return true;
        }
        return false;
    }

    private static byte[] createRenegotiationInfo(byte[] renegotiated_connection) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsUtils.writeOpaque8(renegotiated_connection, buf);
        return buf.toByteArray();
    }

    private static void writeExtension(OutputStream output, Integer extType, byte[] extValue) throws IOException {
        TlsUtils.writeUint16(extType, output);
        TlsUtils.writeOpaque16(extValue, output);
    }
}

