/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.jcajce.b;
import com.timevale.tgtext.bouncycastle.cms.jcajce.c;
import com.timevale.tgtext.bouncycastle.cms.jcajce.d;
import com.timevale.tgtext.bouncycastle.cms.jcajce.e;
import com.timevale.tgtext.bouncycastle.jcajce.io.MacOutputStream;
import com.timevale.tgtext.bouncycastle.operator.GenericKey;
import com.timevale.tgtext.bouncycastle.operator.MacCalculator;
import com.timevale.tgtext.bouncycastle.operator.jcajce.JceGenericKey;
import java.io.OutputStream;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public class JceCMSMacCalculatorBuilder {
    private final ASN1ObjectIdentifier macOID;
    private final int keySize;
    private c helper = new c(new b());
    private SecureRandom random;

    public JceCMSMacCalculatorBuilder(ASN1ObjectIdentifier macOID) {
        this(macOID, -1);
    }

    public JceCMSMacCalculatorBuilder(ASN1ObjectIdentifier macOID, int keySize) {
        this.macOID = macOID;
        this.keySize = keySize;
    }

    public JceCMSMacCalculatorBuilder setProvider(Provider provider) {
        this.helper = new c(new e(provider));
        return this;
    }

    public JceCMSMacCalculatorBuilder setProvider(String providerName) {
        this.helper = new c(new d(providerName));
        return this;
    }

    public JceCMSMacCalculatorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public MacCalculator build() throws CMSException {
        return new a(this.macOID, this.keySize, this.random);
    }

    private class a
    implements MacCalculator {
        private SecretKey b;
        private AlgorithmIdentifier c;
        private Mac d;
        private SecureRandom e;

        a(ASN1ObjectIdentifier macOID, int keySize, SecureRandom random) throws CMSException {
            KeyGenerator keyGen = JceCMSMacCalculatorBuilder.this.helper.i(macOID);
            if (random == null) {
                random = new SecureRandom();
            }
            this.e = random;
            if (keySize < 0) {
                keyGen.init(random);
            } else {
                keyGen.init(keySize, random);
            }
            this.b = keyGen.generateKey();
            AlgorithmParameterSpec paramSpec = this.a(macOID, this.b);
            this.c = JceCMSMacCalculatorBuilder.this.helper.a(macOID, paramSpec);
            this.d = JceCMSMacCalculatorBuilder.this.helper.b(this.b, this.c);
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.c;
        }

        @Override
        public OutputStream getOutputStream() {
            return new MacOutputStream(this.d);
        }

        @Override
        public byte[] getMac() {
            return this.d.doFinal();
        }

        @Override
        public GenericKey getKey() {
            return new JceGenericKey(this.c, this.b);
        }

        protected AlgorithmParameterSpec a(ASN1ObjectIdentifier macOID, SecretKey encKey) throws CMSException {
            try {
                if (macOID.equals(PKCSObjectIdentifiers.RC2_CBC)) {
                    byte[] iv = new byte[8];
                    this.e.nextBytes(iv);
                    return new RC2ParameterSpec(encKey.getEncoded().length << 3, iv);
                }
                AlgorithmParameterGenerator pGen = JceCMSMacCalculatorBuilder.this.helper.f(macOID);
                AlgorithmParameters p2 = pGen.generateParameters();
                return p2.getParameterSpec(IvParameterSpec.class);
            }
            catch (GeneralSecurityException generalSecurityException) {
                return null;
            }
        }
    }
}

