/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.Mac;
import com.timevale.tgtext.bouncycastle.crypto.macs.HMac;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.tls.ProtocolVersion;
import com.timevale.tgtext.bouncycastle.crypto.tls.SSL3Mac;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsClientContext;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsUtils;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class TlsMac {
    protected TlsClientContext context;
    protected long seqNo;
    protected byte[] secret;
    protected Mac mac;

    public TlsMac(TlsClientContext context, Digest digest, byte[] key_block, int offset, int len) {
        this.context = context;
        this.seqNo = 0L;
        KeyParameter param = new KeyParameter(key_block, offset, len);
        this.secret = Arrays.clone(param.getKey());
        boolean isTls = context.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        this.mac = isTls ? new HMac(digest) : new SSL3Mac(digest);
        this.mac.init(param);
    }

    public byte[] getMACSecret() {
        return this.secret;
    }

    public long getSequenceNumber() {
        return this.seqNo;
    }

    public void incSequenceNumber() {
        ++this.seqNo;
    }

    public int getSize() {
        return this.mac.getMacSize();
    }

    public byte[] calculateMac(short type, byte[] message, int offset, int len) {
        ProtocolVersion serverVersion = this.context.getServerVersion();
        boolean isTls = serverVersion.getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        ByteArrayOutputStream bosMac = new ByteArrayOutputStream(isTls ? 13 : 11);
        try {
            TlsUtils.writeUint64(this.seqNo++, bosMac);
            TlsUtils.writeUint8(type, bosMac);
            if (isTls) {
                TlsUtils.writeVersion(serverVersion, bosMac);
            }
            TlsUtils.writeUint16(len, bosMac);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Internal error during mac calculation");
        }
        byte[] macHeader = bosMac.toByteArray();
        this.mac.update(macHeader, 0, macHeader.length);
        this.mac.update(message, offset, len);
        byte[] result = new byte[this.mac.getMacSize()];
        this.mac.doFinal(result, 0);
        return result;
    }

    public byte[] calculateMacConstantTime(short type, byte[] message, int offset, int len, int fullLength, byte[] dummyData) {
        byte[] result = this.calculateMac(type, message, offset, len);
        ProtocolVersion serverVersion = this.context.getServerVersion();
        boolean isTls = serverVersion.getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        if (isTls) {
            int L1 = fullLength + 13;
            int L2 = len + 13;
            int extra = (L1 + 8) / 64 - (L2 + 8) / 64;
            while (--extra >= 0) {
                this.mac.update(dummyData, 0, 64);
            }
            this.mac.update(dummyData[0]);
            this.mac.reset();
        }
        return result;
    }
}

