/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.seal.graphics;

import com.timevale.seal.graphics.TextFont;
import com.timevale.seal.graphics.suites.impl.b;
import esign.utils.constant.type.Color;
import esign.utils.exception.ag;
import esign.utils.exception.aj;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.io.UnsupportedEncodingException;

public class GraphicsTextFont {
    private transient char character;
    private TextFont font = TextFont.SIMSUN;
    private int fontSize = 200;
    private Color color = Color.RED;
    private Integer fontRealWidth;
    private Integer fontRealHeight;

    public void cloneFrom(GraphicsTextFont that) {
        this.setColor(that.getColor());
        this.setFont(that.getFont());
        this.setFontSize(that.getFontSize());
        this.setFontRealHeight(that.getFontRealHeight());
        this.setFontRealWidth(that.getFontRealWidth());
    }

    public TextFont getFont() {
        return this.font;
    }

    public void setFont(TextFont font) {
        if (font == null) {
            return;
        }
        this.font = font;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Integer fontSize) {
        if (fontSize == null) {
            return;
        }
        this.fontSize = fontSize;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.color = color;
    }

    public Integer getFontRealWidth() {
        return this.fontRealWidth;
    }

    public void setFontRealWidth(Integer fontRealWidth) {
        this.fontRealWidth = fontRealWidth;
    }

    public Integer getFontRealHeight() {
        return this.fontRealHeight;
    }

    public void setFontRealHeight(Integer fontRealHeight) {
        this.fontRealHeight = fontRealHeight;
    }

    protected void draw(float x2, float y2, Graphics2D g2) throws aj {
        FontMetrics fm = g2.getFontMetrics();
        b scale = this.scaleCharacter(fm, this.character, this.getFontRealWidth(), this.getFontRealHeight());
        float baselineOffsetY = (float)(-fm.getDescent()) * scale.b();
        float baselineOffsetX = ((float)this.getFontRealWidth().intValue() - (float)fm.charWidth(this.character) * scale.a()) / 2.0f;
        g2.translate(x2 + baselineOffsetX, y2 + baselineOffsetY);
        g2.scale(scale.a(), scale.b());
        g2.drawString(String.valueOf(this.character), 0, 0);
        g2.scale(1.0f / scale.a(), 1.0f / scale.b());
        g2.translate(-x2 - baselineOffsetX, -y2 - baselineOffsetY);
    }

    private b scaleCharacter(FontMetrics fm, char character, Integer width, Integer height) throws aj {
        int ch = fm.getHeight() - fm.getLeading();
        int cw = fm.charWidth(character);
        float scaleX = width == null ? 1.0f : (float)width.intValue() / (float)cw;
        float scaleY = height == null ? 1.0f : (float)height.intValue() / (float)ch;
        try {
            if (1 == new Character(character).toString().getBytes("utf-8").length) {
                return new b(scaleY, scaleY);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ag.ar.a("utf-8");
        }
        return new b(scaleX, scaleY);
    }

    public void setCharacter(char character) {
        this.character = character;
    }
}

