/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.BERSequenceGenerator;
import com.timevale.tgtext.bouncycastle.asn1.DERSequenceGenerator;
import com.timevale.tgtext.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.cms.i;
import com.timevale.tgtext.bouncycastle.operator.OutputCompressor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class CMSCompressedDataStreamGenerator {
    public static final String ZLIB = "1.2.840.113549.1.9.16.3.8";
    private int _bufferSize;

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public OutputStream open(OutputStream out, String compressionOID) throws IOException {
        return this.open(out, CMSObjectIdentifiers.data.getId(), compressionOID);
    }

    public OutputStream open(OutputStream out, String contentOID, String compressionOID) throws IOException {
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.compressedData);
        BERSequenceGenerator cGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        cGen.addObject(new ASN1Integer(0L));
        DERSequenceGenerator algGen = new DERSequenceGenerator(cGen.getRawOutputStream());
        algGen.addObject(new ASN1ObjectIdentifier(ZLIB));
        algGen.close();
        BERSequenceGenerator eiGen = new BERSequenceGenerator(cGen.getRawOutputStream());
        eiGen.addObject(new ASN1ObjectIdentifier(contentOID));
        OutputStream octetStream = i.a(eiGen.getRawOutputStream(), 0, true, this._bufferSize);
        return new a(new DeflaterOutputStream(octetStream), sGen, cGen, eiGen);
    }

    public OutputStream open(OutputStream out, OutputCompressor compressor) throws IOException {
        return this.open(CMSObjectIdentifiers.data, out, compressor);
    }

    public OutputStream open(ASN1ObjectIdentifier contentOID, OutputStream out, OutputCompressor compressor) throws IOException {
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.compressedData);
        BERSequenceGenerator cGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        cGen.addObject(new ASN1Integer(0L));
        cGen.addObject(compressor.getAlgorithmIdentifier());
        BERSequenceGenerator eiGen = new BERSequenceGenerator(cGen.getRawOutputStream());
        eiGen.addObject(contentOID);
        OutputStream octetStream = i.a(eiGen.getRawOutputStream(), 0, true, this._bufferSize);
        return new a(compressor.getOutputStream(octetStream), sGen, cGen, eiGen);
    }

    private class a
    extends OutputStream {
        private OutputStream b;
        private BERSequenceGenerator c;
        private BERSequenceGenerator d;
        private BERSequenceGenerator e;

        a(OutputStream out, BERSequenceGenerator sGen, BERSequenceGenerator cGen, BERSequenceGenerator eiGen) {
            this.b = out;
            this.c = sGen;
            this.d = cGen;
            this.e = eiGen;
        }

        @Override
        public void write(int b2) throws IOException {
            this.b.write(b2);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.b.write(bytes, off, len);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.b.write(bytes);
        }

        @Override
        public void close() throws IOException {
            this.b.close();
            this.e.close();
            this.d.close();
            this.c.close();
        }
    }
}

