/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.ocsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Exception;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.OCSPResponse;
import com.timevale.tgtext.bouncycastle.asn1.ocsp.ResponseBytes;
import com.timevale.tgtext.bouncycastle.cert.CertIOException;
import com.timevale.tgtext.bouncycastle.cert.ocsp.BasicOCSPResp;
import com.timevale.tgtext.bouncycastle.cert.ocsp.OCSPException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class OCSPResp {
    public static final int SUCCESSFUL = 0;
    public static final int MALFORMED_REQUEST = 1;
    public static final int INTERNAL_ERROR = 2;
    public static final int TRY_LATER = 3;
    public static final int SIG_REQUIRED = 5;
    public static final int UNAUTHORIZED = 6;
    private OCSPResponse resp;

    public OCSPResp(OCSPResponse resp) {
        this.resp = resp;
    }

    public OCSPResp(byte[] resp) throws IOException {
        this(new ByteArrayInputStream(resp));
    }

    public OCSPResp(InputStream resp) throws IOException {
        this(new ASN1InputStream(resp));
    }

    private OCSPResp(ASN1InputStream aIn) throws IOException {
        try {
            this.resp = OCSPResponse.getInstance(aIn.readObject());
            return;
        }
        catch (IllegalArgumentException e2) {
            throw new CertIOException("malformed response: " + e2.getMessage(), e2);
        }
        catch (ClassCastException e3) {
            throw new CertIOException("malformed response: " + e3.getMessage(), e3);
        }
        catch (ASN1Exception e4) {
            throw new CertIOException("malformed response: " + e4.getMessage(), e4);
        }
    }

    public int getStatus() {
        return this.resp.getResponseStatus().getValue().intValue();
    }

    public Object getResponseObject() throws OCSPException {
        ResponseBytes rb = this.resp.getResponseBytes();
        if (rb == null) {
            return null;
        }
        if (rb.getResponseType().equals(OCSPObjectIdentifiers.id_pkix_ocsp_basic)) {
            try {
                ASN1Primitive obj = ASN1Primitive.fromByteArray(rb.getResponse().getOctets());
                return new BasicOCSPResp(BasicOCSPResponse.getInstance(obj));
            }
            catch (Exception e2) {
                throw new OCSPException("problem decoding object: " + e2, e2);
            }
        }
        return rb.getResponse();
    }

    public byte[] getEncoded() throws IOException {
        return this.resp.getEncoded();
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof OCSPResp)) {
            return false;
        }
        OCSPResp r2 = (OCSPResp)o2;
        return this.resp.equals(r2.resp);
    }

    public int hashCode() {
        return this.resp.hashCode();
    }
}

