/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.params;

import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.NTRUSigningParameters;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.IntegerPolynomial;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NTRUSigningPublicKeyParameters
extends AsymmetricKeyParameter {
    private NTRUSigningParameters params;
    public IntegerPolynomial h;

    public NTRUSigningPublicKeyParameters(IntegerPolynomial h2, NTRUSigningParameters params) {
        super(false);
        this.h = h2;
        this.params = params;
    }

    public NTRUSigningPublicKeyParameters(byte[] b2, NTRUSigningParameters params) {
        super(false);
        this.h = IntegerPolynomial.fromBinary(b2, params.N, params.q);
        this.params = params;
    }

    public NTRUSigningPublicKeyParameters(InputStream is, NTRUSigningParameters params) throws IOException {
        super(false);
        this.h = IntegerPolynomial.fromBinary(is, params.N, params.q);
        this.params = params;
    }

    public byte[] getEncoded() {
        return this.h.toBinary(this.params.q);
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.getEncoded());
    }

    public int hashCode() {
        int result = 31 + (this.h == null ? 0 : this.h.hashCode());
        result = result * 31 + (this.params == null ? 0 : this.params.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NTRUSigningPublicKeyParameters other = (NTRUSigningPublicKeyParameters)obj;
        if (this.h == null ? other.h != null : !this.h.equals(other.h)) {
            return false;
        }
        return !(this.params == null ? other.params != null : !this.params.equals(other.params));
    }
}

