/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.operator.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.jcajce.DefaultJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.NamedJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.ProviderJcaJceHelper;
import com.timevale.tgtext.bouncycastle.operator.AsymmetricKeyUnwrapper;
import com.timevale.tgtext.bouncycastle.operator.GenericKey;
import com.timevale.tgtext.bouncycastle.operator.OperatorException;
import com.timevale.tgtext.bouncycastle.operator.jcajce.JceGenericKey;
import com.timevale.tgtext.bouncycastle.operator.jcajce.a;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;

public class JceAsymmetricKeyUnwrapper
extends AsymmetricKeyUnwrapper {
    private a helper = new a(new DefaultJcaJceHelper());
    private Map extraMappings = new HashMap();
    private PrivateKey privKey;

    public JceAsymmetricKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, PrivateKey privKey) {
        super(algorithmIdentifier);
        this.privKey = privKey;
    }

    public JceAsymmetricKeyUnwrapper setProvider(Provider provider) {
        this.helper = new a(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceAsymmetricKeyUnwrapper setProvider(String providerName) {
        this.helper = new a(new NamedJcaJceHelper(providerName));
        return this;
    }

    public JceAsymmetricKeyUnwrapper setAlgorithmMapping(ASN1ObjectIdentifier algorithm, String algorithmName) {
        this.extraMappings.put(algorithm, algorithmName);
        return this;
    }

    @Override
    public GenericKey generateUnwrappedKey(AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedKey) throws OperatorException {
        try {
            Key sKey = null;
            Cipher keyCipher = this.helper.a(this.getAlgorithmIdentifier().getAlgorithm(), this.extraMappings);
            try {
                keyCipher.init(4, this.privKey);
                sKey = keyCipher.unwrap(encryptedKey, this.helper.b(encryptedKeyAlgorithm.getAlgorithm()), 3);
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (ProviderException providerException) {}
            if (sKey == null) {
                keyCipher.init(2, this.privKey);
                sKey = new SecretKeySpec(keyCipher.doFinal(encryptedKey), encryptedKeyAlgorithm.getAlgorithm().getId());
            }
            return new JceGenericKey(encryptedKeyAlgorithm, sKey);
        }
        catch (InvalidKeyException e2) {
            throw new OperatorException("key invalid: " + e2.getMessage(), e2);
        }
        catch (IllegalBlockSizeException e3) {
            throw new OperatorException("illegal blocksize: " + e3.getMessage(), e3);
        }
        catch (BadPaddingException e4) {
            throw new OperatorException("bad padding: " + e4.getMessage(), e4);
        }
    }
}

