/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.services.request;

import android.text.TextUtils;
import com.ksyun.ks3.auth.ValidateUtil;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.model.HttpHeaders;
import com.ksyun.ks3.model.HttpMethod;
import com.ksyun.ks3.model.acl.AccessControlList;
import com.ksyun.ks3.model.acl.CannedAccessControlList;
import com.ksyun.ks3.model.acl.Grant;
import com.ksyun.ks3.model.acl.Permission;
import com.ksyun.ks3.services.request.Ks3HttpRequest;
import java.util.ArrayList;

public class CreateBucketRequest
extends Ks3HttpRequest {
    private static final long serialVersionUID = 8146889469506538093L;
    private CannedAccessControlList cannedAcl;
    private AccessControlList acl = new AccessControlList();

    public CreateBucketRequest(String bucketName) {
        this.setBucketname(bucketName);
    }

    public CreateBucketRequest(String bucketName, AccessControlList list) {
        this.setBucketname(bucketName);
        this.setAcl(list);
    }

    public CreateBucketRequest(String bucketName, CannedAccessControlList list) {
        this.setBucketname(bucketName);
        this.setCannedAcl(list);
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public void setAcl(AccessControlList acl) {
        this.acl = acl;
    }

    @Override
    protected void setupRequest() throws Ks3ClientException {
        this.setHttpMethod(HttpMethod.PUT);
        if (this.cannedAcl != null) {
            this.addHeader(HttpHeaders.CannedAcl.toString(), this.cannedAcl.toString());
        }
        if (this.acl != null) {
            ArrayList<String> grants_fullcontrol = new ArrayList<String>();
            ArrayList<String> grants_read = new ArrayList<String>();
            ArrayList<String> grants_write = new ArrayList<String>();
            for (Grant grant : this.acl.getGrants()) {
                if (grant.getPermission().equals((Object)Permission.FullControl)) {
                    grants_fullcontrol.add("id=\"" + grant.getGrantee().getIdentifier() + "\"");
                    continue;
                }
                if (grant.getPermission().equals((Object)Permission.Read)) {
                    grants_read.add("id=\"" + grant.getGrantee().getIdentifier() + "\"");
                    continue;
                }
                if (!grant.getPermission().equals((Object)Permission.Write)) continue;
                grants_write.add("id=\"" + grant.getGrantee().getIdentifier() + "\"");
            }
            if (grants_fullcontrol.size() > 0) {
                this.addHeader(HttpHeaders.GrantFullControl, TextUtils.join((CharSequence)",", grants_fullcontrol));
            }
            if (grants_read.size() > 0) {
                this.addHeader(HttpHeaders.GrantRead, TextUtils.join((CharSequence)",", grants_read));
            }
            if (grants_write.size() > 0) {
                this.addHeader(HttpHeaders.GrantWrite, TextUtils.join((CharSequence)",", grants_write));
            }
        }
    }

    @Override
    protected void validateParams() throws Ks3ClientException {
        if (ValidateUtil.validateBucketName(this.getBucketname()) == null) {
            throw new Ks3ClientException("bucket name is not correct");
        }
    }
}

