/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import androidx.annotation.Nullable;
import com.vanniktech.emoji.EmojiAutoCompleteTextView;
import com.vanniktech.emoji.EmojiButton;
import com.vanniktech.emoji.EmojiCheckbox;
import com.vanniktech.emoji.EmojiEditText;
import com.vanniktech.emoji.EmojiMultiAutoCompleteTextView;
import com.vanniktech.emoji.EmojiTextView;

public class EmojiLayoutFactory
implements LayoutInflater.Factory2 {
    @Nullable
    private final LayoutInflater.Factory2 delegate;

    public EmojiLayoutFactory() {
        this.delegate = null;
    }

    public EmojiLayoutFactory(@Nullable LayoutInflater.Factory2 delegate) {
        this.delegate = delegate;
    }

    public View onCreateView(@Nullable View parent, String name, Context context, AttributeSet attrs) {
        if ("TextView".equals(name)) {
            return new EmojiTextView(context, attrs);
        }
        if ("EditText".equals(name)) {
            return new EmojiEditText(context, attrs);
        }
        if ("Button".equals(name)) {
            return new EmojiButton(context, attrs);
        }
        if ("Checkbox".equals(name)) {
            return new EmojiCheckbox(context, attrs);
        }
        if ("AutoCompleteTextView".equals(name)) {
            return new EmojiAutoCompleteTextView(context, attrs);
        }
        if ("MultiAutoCompleteTextView".equals(name)) {
            return new EmojiMultiAutoCompleteTextView(context, attrs);
        }
        if (this.delegate != null) {
            return this.delegate.onCreateView(parent, name, context, attrs);
        }
        return null;
    }

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        return this.onCreateView(null, name, context, attrs);
    }
}

