/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter.Fresco;

import android.content.res.Resources;
import android.graphics.ColorFilter;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.Preconditions;
import com.facebook.drawee.drawable.DrawableParent;
import com.facebook.drawee.drawable.FadeDrawable;
import com.facebook.drawee.drawable.ForwardingDrawable;
import com.facebook.drawee.drawable.MatrixDrawable;
import com.facebook.drawee.drawable.ScaleTypeDrawable;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.RoundingParams;
import com.facebook.drawee.interfaces.SettableDraweeHierarchy;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import io.dcloud.feature.weex.adapter.Fresco.DCGenericDraweeHierarchyBuilder;
import io.dcloud.feature.weex.adapter.Fresco.DCRootDrawable;
import io.dcloud.feature.weex.adapter.Fresco.DCWrappingUtils;

public class DCGenericDraweeHierarchy
implements SettableDraweeHierarchy {
    private static final int BACKGROUND_IMAGE_INDEX = 0;
    private static final int PLACEHOLDER_IMAGE_INDEX = 1;
    private static final int ACTUAL_IMAGE_INDEX = 2;
    private static final int PROGRESS_BAR_IMAGE_INDEX = 3;
    private static final int RETRY_IMAGE_INDEX = 4;
    private static final int FAILURE_IMAGE_INDEX = 5;
    private static final int OVERLAY_IMAGES_INDEX = 6;
    private final Drawable mEmptyActualImageDrawable = new ColorDrawable(0);
    private final Resources mResources;
    @Nullable
    private RoundingParams mRoundingParams;
    private final DCRootDrawable mTopLevelDrawable;
    private final FadeDrawable mFadeDrawable;
    private final ForwardingDrawable mActualImageWrapper;

    DCGenericDraweeHierarchy(DCGenericDraweeHierarchyBuilder builder) {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"GenericDraweeHierarchy()");
        }
        this.mResources = builder.getResources();
        this.mRoundingParams = builder.getRoundingParams();
        this.mActualImageWrapper = new ForwardingDrawable(this.mEmptyActualImageDrawable);
        int numOverlays = builder.getOverlays() != null ? builder.getOverlays().size() : 1;
        int numLayers = 6 + (numOverlays += builder.getPressedStateOverlay() != null ? 1 : 0);
        Drawable[] layers = new Drawable[numLayers];
        layers[0] = this.buildBranch(builder.getBackground(), null);
        layers[1] = this.buildBranch(builder.getPlaceholderImage(), builder.getPlaceholderImageScaleType());
        layers[2] = this.buildActualImageBranch((Drawable)this.mActualImageWrapper, builder.getActualImageScaleType(), builder.getActualImageFocusPoint(), builder.getActualImageColorFilter());
        layers[3] = this.buildBranch(builder.getProgressBarImage(), builder.getProgressBarImageScaleType());
        layers[4] = this.buildBranch(builder.getRetryImage(), builder.getRetryImageScaleType());
        layers[5] = this.buildBranch(builder.getFailureImage(), builder.getFailureImageScaleType());
        if (numOverlays > 0) {
            int index = 0;
            if (builder.getOverlays() != null) {
                for (Drawable overlay : builder.getOverlays()) {
                    layers[6 + index++] = this.buildBranch(overlay, null);
                }
            } else {
                index = 1;
            }
            if (builder.getPressedStateOverlay() != null) {
                layers[6 + index] = this.buildBranch(builder.getPressedStateOverlay(), null);
            }
        }
        this.mFadeDrawable = new FadeDrawable(layers);
        this.mFadeDrawable.setTransitionDuration(builder.getFadeDuration());
        Drawable maybeRoundedDrawable = DCWrappingUtils.maybeWrapWithRoundedOverlayColor((Drawable)this.mFadeDrawable, this.mRoundingParams);
        this.mTopLevelDrawable = new DCRootDrawable(maybeRoundedDrawable);
        this.mTopLevelDrawable.mutate();
        this.resetFade();
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
    }

    @Nullable
    private Drawable buildActualImageBranch(Drawable drawable2, @Nullable ScalingUtils.ScaleType scaleType, @Nullable PointF focusPoint, @Nullable ColorFilter colorFilter) {
        drawable2.setColorFilter(colorFilter);
        drawable2 = DCWrappingUtils.maybeWrapWithScaleType(drawable2, scaleType, focusPoint);
        return drawable2;
    }

    @Nullable
    private Drawable buildBranch(@Nullable Drawable drawable2, @Nullable ScalingUtils.ScaleType scaleType) {
        drawable2 = DCWrappingUtils.maybeApplyLeafRounding(drawable2, this.mRoundingParams, this.mResources);
        drawable2 = DCWrappingUtils.maybeWrapWithScaleType(drawable2, scaleType);
        return drawable2;
    }

    private void resetActualImages() {
        this.mActualImageWrapper.setDrawable(this.mEmptyActualImageDrawable);
    }

    private void resetFade() {
        if (this.mFadeDrawable != null) {
            this.mFadeDrawable.beginBatchMode();
            this.mFadeDrawable.fadeInAllLayers();
            this.fadeOutBranches();
            this.fadeInLayer(1);
            this.mFadeDrawable.finishTransitionImmediately();
            this.mFadeDrawable.endBatchMode();
        }
    }

    private void fadeOutBranches() {
        this.fadeOutLayer(1);
        this.fadeOutLayer(2);
        this.fadeOutLayer(3);
        this.fadeOutLayer(4);
        this.fadeOutLayer(5);
    }

    private void fadeInLayer(int index) {
        if (index >= 0) {
            this.mFadeDrawable.fadeInLayer(index);
        }
    }

    private void fadeOutLayer(int index) {
        if (index >= 0) {
            this.mFadeDrawable.fadeOutLayer(index);
        }
    }

    private void setProgress(float progress) {
        Drawable progressBarDrawable = this.mFadeDrawable.getDrawable(3);
        if (progressBarDrawable == null) {
            return;
        }
        if (progress >= 0.999f) {
            if (progressBarDrawable instanceof Animatable) {
                ((Animatable)progressBarDrawable).stop();
            }
            this.fadeOutLayer(3);
        } else {
            if (progressBarDrawable instanceof Animatable) {
                ((Animatable)progressBarDrawable).start();
            }
            this.fadeInLayer(3);
        }
        progressBarDrawable.setLevel(Math.round(progress * 10000.0f));
    }

    public DCRootDrawable getTopLevelDrawable() {
        return this.mTopLevelDrawable;
    }

    public Rect getBounds() {
        return this.mTopLevelDrawable.getBounds();
    }

    public void reset() {
        this.resetActualImages();
        this.resetFade();
    }

    public void setImage(Drawable drawable2, float progress, boolean immediate) {
        drawable2 = DCWrappingUtils.maybeApplyLeafRounding(drawable2, this.mRoundingParams, this.mResources);
        drawable2.mutate();
        this.mActualImageWrapper.setDrawable(drawable2);
        this.mFadeDrawable.beginBatchMode();
        this.fadeOutBranches();
        this.fadeInLayer(2);
        this.setProgress(progress);
        if (immediate) {
            this.mFadeDrawable.finishTransitionImmediately();
        }
        this.mFadeDrawable.endBatchMode();
    }

    public void setProgress(float progress, boolean immediate) {
        if (this.mFadeDrawable.getDrawable(3) == null) {
            return;
        }
        this.mFadeDrawable.beginBatchMode();
        this.setProgress(progress);
        if (immediate) {
            this.mFadeDrawable.finishTransitionImmediately();
        }
        this.mFadeDrawable.endBatchMode();
    }

    public void setFailure(Throwable throwable) {
        this.mFadeDrawable.beginBatchMode();
        this.fadeOutBranches();
        if (this.mFadeDrawable.getDrawable(5) != null) {
            this.fadeInLayer(5);
        } else {
            this.fadeInLayer(1);
        }
        this.mFadeDrawable.endBatchMode();
    }

    public void setRetry(Throwable throwable) {
        this.mFadeDrawable.beginBatchMode();
        this.fadeOutBranches();
        if (this.mFadeDrawable.getDrawable(4) != null) {
            this.fadeInLayer(4);
        } else {
            this.fadeInLayer(1);
        }
        this.mFadeDrawable.endBatchMode();
    }

    public void setControllerOverlay(@Nullable Drawable drawable2) {
        this.mTopLevelDrawable.setControllerOverlay(drawable2);
    }

    private DrawableParent getParentDrawableAtIndex(int index) {
        DrawableParent parent = this.mFadeDrawable.getDrawableParentForIndex(index);
        if (parent.getDrawable() instanceof MatrixDrawable) {
            parent = (MatrixDrawable)parent.getDrawable();
        }
        if (parent.getDrawable() instanceof ScaleTypeDrawable) {
            parent = (ScaleTypeDrawable)parent.getDrawable();
        }
        return parent;
    }

    private void setChildDrawableAtIndex(int index, @Nullable Drawable drawable2) {
        if (drawable2 == null) {
            this.mFadeDrawable.setDrawable(index, null);
            return;
        }
        drawable2 = DCWrappingUtils.maybeApplyLeafRounding(drawable2, this.mRoundingParams, this.mResources);
        this.getParentDrawableAtIndex(index).setDrawable(drawable2);
    }

    private ScaleTypeDrawable getScaleTypeDrawableAtIndex(int index) {
        DrawableParent parent = this.getParentDrawableAtIndex(index);
        if (parent instanceof ScaleTypeDrawable) {
            return (ScaleTypeDrawable)parent;
        }
        return DCWrappingUtils.wrapChildWithScaleType(parent, ScalingUtils.ScaleType.FIT_XY);
    }

    private boolean hasScaleTypeDrawableAtIndex(int index) {
        DrawableParent parent = this.getParentDrawableAtIndex(index);
        return parent instanceof ScaleTypeDrawable;
    }

    public void setFadeDuration(int durationMs) {
        this.mFadeDrawable.setTransitionDuration(durationMs);
    }

    public int getFadeDuration() {
        return this.mFadeDrawable.getTransitionDuration();
    }

    public void setActualImageFocusPoint(PointF focusPoint) {
        Preconditions.checkNotNull((Object)focusPoint);
        this.getScaleTypeDrawableAtIndex(2).setFocusPoint(focusPoint);
    }

    public void setActualImageScaleType(ScalingUtils.ScaleType scaleType) {
        Preconditions.checkNotNull((Object)scaleType);
        this.getScaleTypeDrawableAtIndex(2).setScaleType(scaleType);
    }

    @Nullable
    public ScalingUtils.ScaleType getActualImageScaleType() {
        if (!this.hasScaleTypeDrawableAtIndex(2)) {
            return null;
        }
        return this.getScaleTypeDrawableAtIndex(2).getScaleType();
    }

    public void setActualImageColorFilter(ColorFilter colorfilter) {
        this.mActualImageWrapper.setColorFilter(colorfilter);
    }

    public void getActualImageBounds(RectF outBounds) {
        this.mActualImageWrapper.getTransformedBounds(outBounds);
    }

    public void setPlaceholderImage(@Nullable Drawable drawable2) {
        this.setChildDrawableAtIndex(1, drawable2);
    }

    public void setPlaceholderImage(Drawable drawable2, ScalingUtils.ScaleType scaleType) {
        this.setChildDrawableAtIndex(1, drawable2);
        this.getScaleTypeDrawableAtIndex(1).setScaleType(scaleType);
    }

    public boolean hasPlaceholderImage() {
        return this.mFadeDrawable.getDrawable(1) != null;
    }

    public void setPlaceholderImageFocusPoint(PointF focusPoint) {
        Preconditions.checkNotNull((Object)focusPoint);
        this.getScaleTypeDrawableAtIndex(1).setFocusPoint(focusPoint);
    }

    public void setPlaceholderImage(int resourceId) {
        this.setPlaceholderImage(this.mResources.getDrawable(resourceId));
    }

    public void setPlaceholderImage(int resourceId, ScalingUtils.ScaleType scaleType) {
        this.setPlaceholderImage(this.mResources.getDrawable(resourceId), scaleType);
    }

    public void setFailureImage(@Nullable Drawable drawable2) {
        this.setChildDrawableAtIndex(5, drawable2);
    }

    public void setFailureImage(Drawable drawable2, ScalingUtils.ScaleType scaleType) {
        this.setChildDrawableAtIndex(5, drawable2);
        this.getScaleTypeDrawableAtIndex(5).setScaleType(scaleType);
    }

    public void setFailureImage(int resourceId) {
        this.setFailureImage(this.mResources.getDrawable(resourceId));
    }

    public void setFailureImage(int resourceId, ScalingUtils.ScaleType scaleType) {
        this.setFailureImage(this.mResources.getDrawable(resourceId), scaleType);
    }

    public void setRetryImage(@Nullable Drawable drawable2) {
        this.setChildDrawableAtIndex(4, drawable2);
    }

    public void setRetryImage(Drawable drawable2, ScalingUtils.ScaleType scaleType) {
        this.setChildDrawableAtIndex(4, drawable2);
        this.getScaleTypeDrawableAtIndex(4).setScaleType(scaleType);
    }

    public void setRetryImage(int resourceId) {
        this.setRetryImage(this.mResources.getDrawable(resourceId));
    }

    public void setRetryImage(int resourceId, ScalingUtils.ScaleType scaleType) {
        this.setRetryImage(this.mResources.getDrawable(resourceId), scaleType);
    }

    public void setProgressBarImage(@Nullable Drawable drawable2) {
        this.setChildDrawableAtIndex(3, drawable2);
    }

    public void setProgressBarImage(Drawable drawable2, ScalingUtils.ScaleType scaleType) {
        this.setChildDrawableAtIndex(3, drawable2);
        this.getScaleTypeDrawableAtIndex(3).setScaleType(scaleType);
    }

    public void setProgressBarImage(int resourceId) {
        this.setProgressBarImage(this.mResources.getDrawable(resourceId));
    }

    public void setProgressBarImage(int resourceId, ScalingUtils.ScaleType scaleType) {
        this.setProgressBarImage(this.mResources.getDrawable(resourceId), scaleType);
    }

    public void setBackgroundImage(@Nullable Drawable drawable2) {
        this.setChildDrawableAtIndex(0, drawable2);
    }

    public void setOverlayImage(int index, @Nullable Drawable drawable2) {
        Preconditions.checkArgument((index >= 0 && 6 + index < this.mFadeDrawable.getNumberOfLayers() ? 1 : 0) != 0, (Object)"The given index does not correspond to an overlay image.");
        this.setChildDrawableAtIndex(6 + index, drawable2);
    }

    public void setOverlayImage(@Nullable Drawable drawable2) {
        this.setOverlayImage(0, drawable2);
    }

    public void setRoundingParams(@Nullable RoundingParams roundingParams) {
        this.mRoundingParams = roundingParams;
        DCWrappingUtils.updateOverlayColorRounding((DrawableParent)this.mTopLevelDrawable, this.mRoundingParams);
        for (int i = 0; i < this.mFadeDrawable.getNumberOfLayers(); ++i) {
            DCWrappingUtils.updateLeafRounding(this.getParentDrawableAtIndex(i), this.mRoundingParams, this.mResources);
        }
    }

    @Nullable
    public RoundingParams getRoundingParams() {
        return this.mRoundingParams;
    }

    @VisibleForTesting
    public boolean hasImage() {
        return this.mActualImageWrapper.getDrawable() != this.mEmptyActualImageDrawable;
    }
}

