/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.services.request;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.ksyun.ks3.auth.AuthEvent;
import com.ksyun.ks3.auth.AuthEventCode;
import com.ksyun.ks3.auth.AuthUtils;
import com.ksyun.ks3.auth.DefaultSigner;
import com.ksyun.ks3.auth.RepeatableInputStreamRequestEntity;
import com.ksyun.ks3.exception.Ks3ClientException;
import com.ksyun.ks3.model.AsyncHttpRequsetParam;
import com.ksyun.ks3.model.HttpHeaders;
import com.ksyun.ks3.model.HttpMethod;
import com.ksyun.ks3.model.acl.Authorization;
import com.ksyun.ks3.model.transfer.MD5DigestCalculatingInputStream;
import com.ksyun.ks3.model.transfer.RequestProgressListener;
import com.ksyun.ks3.services.AuthListener;
import com.ksyun.ks3.services.AuthResult;
import com.ksyun.ks3.services.Ks3AuthHandler;
import com.ksyun.ks3.services.Ks3ClientConfiguration;
import com.ksyun.ks3.services.ServerDateAuthListener;
import com.ksyun.ks3.services.request.MD5CalculateAble;
import com.ksyun.ks3.util.ByteUtil;
import com.ksyun.ks3.util.DateUtil;
import com.ksyun.ks3.util.HttpUtils;
import com.ksyun.ks3.util.RequestUtils;
import com.ksyun.ks3.util.StringUtils;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.RequestHandle;
import cz.msebera.android.httpclient.HttpEntity;
import cz.msebera.android.httpclient.entity.BufferedHttpEntity;
import cz.msebera.android.httpclient.entity.StringEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Ks3HttpRequest
implements Serializable {
    private static final long serialVersionUID = -5871616471337887313L;
    private String url;
    private String bucketname;
    private String objectkey;
    private String paramsToSign = "";
    private HttpEntity entity;
    private InputStream requestBody;
    private HttpMethod httpMethod;
    private Map<String, String> header = new HashMap<String, String>();
    private Map<String, String> params = new HashMap<String, String>();
    private Authorization authorization;
    private Context context;
    private AsyncHttpRequsetParam asyncHttpRequestParam;
    private AuthListener authListener;
    private String authorizationStr;
    private RequestProgressListener progressListener;
    private RequestHandle handler;
    private static final Pattern ENCODED_CHARACTERS_PATTERN;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setBucketname(String bucketname) {
        this.bucketname = bucketname;
    }

    public String getBucketname() {
        return this.bucketname;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public void setEntity(HttpEntity entity) {
        this.entity = entity;
    }

    public String getEndpoint() {
        return this.header.get(HttpHeaders.Host.toString());
    }

    public void setEndpoint(String endpoint) {
        this.addHeader(HttpHeaders.Host.toString(), endpoint);
    }

    public void setObjectkey(String objectkey) {
        this.objectkey = objectkey;
    }

    public String getObjectkey() {
        return this.objectkey;
    }

    public void setAuthorization(Authorization authorization) {
        this.authorization = authorization;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public InputStream getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(InputStream requestBody) {
        this.requestBody = requestBody;
    }

    public void addHeader(String key, String value) {
        this.header.put(key, value);
    }

    protected void addHeader(HttpHeaders key, String value) {
        this.addHeader(key.toString(), value);
    }

    public void setHeader(Map<String, String> header) {
        this.header = header;
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    protected void setParamsToSign(String paramsToSign) {
        this.paramsToSign = paramsToSign;
    }

    public String getParamsToSign() {
        return this.paramsToSign;
    }

    protected void addParams(String key, String value) {
        this.params.put(key, value);
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    protected void setContentMD5(String md5) {
        if (!StringUtils.isBlank(md5)) {
            this.addHeader(HttpHeaders.ContentMD5.toString(), md5);
        }
    }

    public String getContentMD5() {
        String res = this.header.get(HttpHeaders.ContentMD5.toString());
        return res == null ? "" : res;
    }

    public void setContentType(String type) {
        this.header.put(HttpHeaders.ContentType.toString(), type);
    }

    public String getContentType() {
        String res = this.header.get(HttpHeaders.ContentType.toString());
        return res == null ? "" : res;
    }

    public String getDate() {
        String s = this.header.get(HttpHeaders.Date.toString());
        if (TextUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        return s;
    }

    protected void setDate(String string) {
        this.addHeader(HttpHeaders.Date.toString(), string);
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public AsyncHttpRequsetParam getAsyncHttpRequestParam() {
        return this.asyncHttpRequestParam;
    }

    public void setAsyncHttpRequestParam(AsyncHttpRequsetParam asyncHttpRequestParam) {
        this.asyncHttpRequestParam = asyncHttpRequestParam;
    }

    public void completeRequset(Ks3AuthHandler ks3AuthHandler, AsyncHttpResponseHandler handler) throws Ks3ClientException {
        this.validateParams();
        this.setupRequestDefault();
        this.setupRequest();
        if (StringUtils.isBlank(this.getContentType())) {
            this.setContentType("text/plain");
        }
        if (handler instanceof RequestProgressListener) {
            this.progressListener = (RequestProgressListener)((Object)handler);
        }
        this.asyncHttpRequestParam = this.finishHttpRequest(ks3AuthHandler);
        if (this.authListener != null && ks3AuthHandler.isNeedCalculateAuth) {
            if (!TextUtils.isEmpty((CharSequence)this.authorizationStr)) {
                AuthEvent event = new AuthEvent();
                event.setCode(AuthEventCode.Success);
                event.setContent(this.authorizationStr);
                Log.d((String)"ks3_android_sdk", (String)("retrieve auth string success :" + this.authorizationStr));
                Log.d((String)"ks3_android_sdk", (String)"make requset complete");
                ks3AuthHandler.onSuccess(event);
            } else {
                AuthEvent event = new AuthEvent();
                event.setCode(AuthEventCode.Failure);
                event.setContent("failure reason : authorizaion is not correct :" + this.authorizationStr);
                Log.d((String)"ks3_android_sdk", (String)"make requset failed");
                ks3AuthHandler.onFailure(event);
            }
        }
        Log.d((String)"ks3_android_sdk", (String)"make requset complete");
    }

    private void setupRequestDefault() {
        this.httpMethod = HttpMethod.POST;
        this.setContentMD5("");
        this.addHeader(HttpHeaders.UserAgent, "ks3-kss-android-sdk/1.5.2");
        this.setDate(DateUtil.GetUTCTime());
    }

    private AsyncHttpRequsetParam finishHttpRequest(Ks3AuthHandler ks3AuthHandler) throws Ks3ClientException {
        if (this instanceof MD5CalculateAble && this.getRequestBody() != null && !(this.getRequestBody() instanceof MD5DigestCalculatingInputStream)) {
            this.setRequestBody(new MD5DigestCalculatingInputStream(this.getRequestBody()));
        }
        String encodedParams = this.encodeParams();
        this.setUrl(this.toUrl());
        if (this.getHttpMethod() == HttpMethod.POST) {
            if (this.requestBody == null && this.params != null) {
                try {
                    this.setEntity(new StringEntity(encodedParams));
                }
                catch (UnsupportedEncodingException e) {
                    throw new Ks3ClientException("Unable to create HTTP entity:" + e, e);
                }
            }
            String length = this.getHeader().get(HttpHeaders.ContentLength.toString());
            HttpEntity entity = new RepeatableInputStreamRequestEntity(this.requestBody, length);
            try {
                entity = new BufferedHttpEntity(entity);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new Ks3ClientException("init http request error(" + e + ")", e);
            }
            this.setEntity(entity);
        } else if (this.getHttpMethod() != HttpMethod.GET) {
            if (this.getHttpMethod() == HttpMethod.PUT) {
                if (this.requestBody != null) {
                    Map<String, String> headrs = this.getHeader();
                    String length = headrs.get(HttpHeaders.ContentLength.toString());
                    if (length == null) {
                        throw new Ks3ClientException("content-length can not be null when put request");
                    }
                    RepeatableInputStreamRequestEntity entity = new RepeatableInputStreamRequestEntity(this.requestBody, length);
                    entity.setProgressLisener(this.progressListener);
                    this.setEntity(entity);
                }
            } else if (this.getHttpMethod() != HttpMethod.DELETE && this.getHttpMethod() != HttpMethod.HEAD) {
                throw new Ks3ClientException("Unknow http method : " + (Object)((Object)this.getHttpMethod()));
            }
        }
        if (!StringUtils.isBlank(this.header.get(HttpHeaders.ContentLength.toString()))) {
            this.header.remove(HttpHeaders.ContentLength.toString());
        }
        if (this.authListener != null) {
            StringBuffer sBuffer = new StringBuffer();
            sBuffer.append(this.getHttpMethod().toString()).append("\n");
            sBuffer.append(this.getContentMD5()).append("\n");
            sBuffer.append(this.getContentType()).append("\n");
            sBuffer.append(this.getDate()).append("\n");
            sBuffer.append(AuthUtils.CanonicalizedKSSHeaders(this)).append("\n");
            sBuffer.append(AuthUtils.CanonicalizedKSSResource(this));
            String signStr = sBuffer.toString();
            Log.i((String)"ks3_android_sdk", (String)("the correct StringToSign should be :" + signStr));
            if (this.authorization != null) {
                Log.i((String)"ks3_android_sdk", (String)("the correct auth string should be " + new DefaultSigner().calculate(this.authorization, this).trim()));
            }
            AuthResult authResult = null;
            if (this.authListener instanceof ServerDateAuthListener) {
                authResult = ((ServerDateAuthListener)this.authListener).onCalculateAuthWithServerDate(this.getHttpMethod().toString(), this.getContentType(), this.getDate(), this.getContentMD5(), AuthUtils.CanonicalizedKSSResource(this), AuthUtils.CanonicalizedKSSHeaders(this));
                this.authorizationStr = authResult.getToken();
                this.setDate(authResult.getDate());
            } else {
                this.authorizationStr = this.authListener.onCalculateAuth(this.getHttpMethod().toString(), this.getContentType(), this.getDate(), this.getContentMD5(), AuthUtils.CanonicalizedKSSResource(this), AuthUtils.CanonicalizedKSSHeaders(this));
            }
            if (this.authorizationStr == null) {
                this.authorizationStr = "";
            }
            Log.i((String)"ks3_android_sdk", (String)("app server return auth string is  :" + this.authorizationStr.trim()));
            this.addHeader(HttpHeaders.Authorization.toString(), this.authorizationStr.trim());
        } else {
            if (this.authorization != null && this.authorization.getSecurityToken() != null) {
                this.addHeader(HttpHeaders.SecurityToken, this.authorization.getSecurityToken());
            }
            this.addHeader(HttpHeaders.Authorization.toString(), new DefaultSigner().calculate(this.authorization, this).trim());
        }
        if (this.entity != null) {
            return new AsyncHttpRequsetParam(this.url, this.getContentType(), this.header, this.params, this.entity);
        }
        return new AsyncHttpRequsetParam(this.url, this.header, this.params);
    }

    private String encodeParams() {
        ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(this.params.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return ByteUtil.compareTo(o1.getKey().toString().getBytes(), o2.getKey().toString().getBytes());
            }
        });
        ArrayList<String> kvList = new ArrayList<String>();
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : arrayList) {
            String value = null;
            String key = ((String)entry.getKey()).replace(String.valueOf('\u200b'), "");
            if (!StringUtils.isBlank((String)entry.getValue())) {
                value = URLEncoder.encode((String)entry.getValue());
            }
            if (RequestUtils.subResource.contains(entry.getKey())) {
                if (value != null && !value.equals("")) {
                    kvList.add(key + "=" + value);
                } else {
                    kvList.add(key);
                }
            }
            if (value != null && !value.equals("")) {
                list.add(key + "=" + value);
                continue;
            }
            if (!RequestUtils.subResource.contains(key)) continue;
            list.add(key);
        }
        String queryParams = TextUtils.join((CharSequence)"&", (Object[])list.toArray());
        this.setParamsToSign(TextUtils.join((CharSequence)"&", (Object[])kvList.toArray()));
        return queryParams;
    }

    protected abstract void setupRequest() throws Ks3ClientException;

    protected abstract void validateParams() throws Ks3ClientException;

    public AuthListener getAuthListener() {
        return this.authListener;
    }

    public void setAuthListener(AuthListener authListener) {
        this.authListener = authListener;
    }

    public void setRequestHandler(RequestHandle handler) {
        if (this.handler != null) {
            Log.e((String)"ks3_android_sdk", (String)"method : setRequestHandler , is an internal method, and the handler is already set up , ingnore ! ");
            return;
        }
        this.handler = handler;
    }

    public boolean abort() {
        if (this.handler != null) {
            return this.handler.cancel(true);
        }
        Log.e((String)"ks3_android_sdk", (String)"the request is on RUNNING status , or the request is on sync mode , igonre abort request ! ");
        return false;
    }

    public static String urlEncode(String value) {
        if (value == null) {
            return "";
        }
        Matcher matcher = ENCODED_CHARACTERS_PATTERN.matcher(value);
        StringBuffer buffer = new StringBuffer(value.length());
        while (matcher.find()) {
            String replacement = matcher.group(0);
            if ("+".equals(replacement)) {
                replacement = "%20";
            } else if ("*".equals(replacement)) {
                replacement = "%2A";
            } else if ("%7E".equals(replacement)) {
                replacement = "~";
            }
            matcher.appendReplacement(buffer, replacement);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    protected void finalize() throws Throwable {
        Log.d((String)"Ks3HttpRequest", (String)("Ks3HttpRequest finalize:" + this));
        super.finalize();
    }

    public String toUrl() {
        String url = "";
        String bucket = this.getBucketname();
        String key = this.getObjectkey();
        String endpoint = this.getEndpoint();
        key = HttpUtils.urlEncode(key, true);
        String encodedParams = HttpUtils.encodeParams(this.getParams());
        boolean pathStyle = Ks3ClientConfiguration.getDefaultConfiguration().isPathStyleAccess();
        boolean domainMode = Ks3ClientConfiguration.getDefaultConfiguration().getDomainMode();
        Ks3ClientConfiguration.PROTOCOL spePro = Ks3ClientConfiguration.getDefaultConfiguration().getProtocol();
        if (spePro == null) {
            spePro = Ks3ClientConfiguration.PROTOCOL.http;
        }
        url = bucket == null || pathStyle ? new StringBuffer().append(endpoint).append(StringUtils.isBlank(bucket) ? "" : "/" + bucket).append(StringUtils.isBlank(key) ? "" : "/" + key).toString() : new StringBuffer().append(endpoint).append(StringUtils.isBlank(key) ? "" : "/" + key).toString();
        url = url.replace("//", "/%2F");
        url = spePro.toString() + "://" + url;
        if (!StringUtils.isBlank(encodedParams)) {
            url = url + "?" + encodedParams;
        }
        return url;
    }

    static {
        StringBuilder pattern = new StringBuilder();
        pattern.append(Pattern.quote("+")).append("|").append(Pattern.quote("*")).append("|").append(Pattern.quote("%7E")).append("|");
        ENCODED_CHARACTERS_PATTERN = Pattern.compile(pattern.toString());
    }
}

