/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core.audio;

import android.content.Context;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import cn.rongcloud.rtc.api.AudioDualMonoMode;
import cn.rongcloud.rtc.api.RCRTCAudioMixer;
import cn.rongcloud.rtc.api.callback.RCRTCAudioMixingStateChangeListener;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.stream.RCMicOutputStreamImpl;
import cn.rongcloud.rtc.core.audio.AudioWriteHelper;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.custom.MediaAudioDecoder;
import cn.rongcloud.rtc.custom.OnPcmAvailableListener;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.jni.audio.RCAudioChannelHandler;
import cn.rongcloud.rtc.utils.AudioBufferStream;
import cn.rongcloud.rtc.utils.AudioUtil;
import cn.rongcloud.rtc.utils.ReportUtil;
import io.rong.common.RLog;
import java.nio.ByteBuffer;

public class AudioMixer
extends RCRTCAudioMixer
implements OnAudioBufferAvailableListener,
OnPcmAvailableListener {
    private static final String TAG = "RongRTCAudioMixer";
    private static AudioMixer sInstance;
    private static final int MAX_VOL = 100;
    private static final int MIN_VOL = 0;
    private static final int STATE_START = 0;
    private static final int STATE_PAUSE = 1;
    private static final int STATE_STOP = 2;
    private MediaAudioDecoder mAudioDecoder;
    private AudioBufferStream mAudioBufferStream;
    private AudioTrack mAudioTrack;
    private RCRTCAudioMixingStateChangeListener audioMixingStateChangeListener;
    private int mState = 2;
    private int mixingVolume = 100;
    private int playbackVolume = 100;
    private long totalDurationUs = 0L;
    private float currentPosition = 0.0f;
    private RCRTCAudioMixer.Mode mode;
    private boolean playback = false;
    private volatile RCMicOutputStreamImpl mDefaultAudioStream;
    private final Object operationBlock = new Object();
    private Handler processHandler;
    private int processInterval = 200;
    private RCAudioChannelHandler mAudioHandler;
    private AudioDualMonoMode mKtvMode = AudioDualMonoMode.AUDIO_DUAL_MONO_STEREO;
    private volatile AudioWriteHelper audioWriteHelper;

    @Deprecated
    public static AudioMixer getInstance() {
        if (null == sInstance) {
            sInstance = new AudioMixer();
        }
        return sInstance;
    }

    public void setDefaultAudioStream(RCMicOutputStreamImpl defaultAudioStream) {
        this.mDefaultAudioStream = defaultAudioStream;
    }

    protected void StateChange(RCRTCAudioMixer.MixingState state, RCRTCAudioMixer.MixingStateReason reason) {
        RCRTCAudioMixingStateChangeListener listener = this.audioMixingStateChangeListener;
        if (null != listener) {
            listener.onStateChanged(state, reason);
        }
    }

    protected void reportPlayingProgress(float progress) {
        RCRTCAudioMixingStateChangeListener listener = this.audioMixingStateChangeListener;
        if (null != listener) {
            listener.onReportPlayingProgress(progress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startMix(String path, RCRTCAudioMixer.Mode mode, boolean playback, int loopCount) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            ReportUtil.libError(ReportUtil.TAG.STARTMIX, RTCErrorCode.RongRTCCodeParameterError, "desc", "- startMix() path is empty !");
            return false;
        }
        if (!RTCEngineImpl.getInstance().validateFilePath(path)) {
            ReportUtil.libError(ReportUtil.TAG.STARTMIX, RTCErrorCode.RongRTCCodeParameterError, "desc", "- path is invalid or not existed !");
            return false;
        }
        Object object = this.operationBlock;
        synchronized (object) {
            RCMicOutputStreamImpl defaultAudioStream = this.mDefaultAudioStream;
            ReportUtil.appTask(ReportUtil.TAG.STARTMIX, "path|mode|playback|loopCount|mixingVolume|playbackVolume", new Object[]{path, mode, playback, loopCount, this.mixingVolume, this.playbackVolume});
            if (this.mState != 2 && defaultAudioStream != null) {
                this.stop(false);
            }
            this.mode = mode;
            this.playback = playback;
            MediaAudioDecoder audioDecoder = new MediaAudioDecoder();
            Context context = RTCEngineImpl.getInstance().getContext();
            if (context == null) {
                ReportUtil.appError(ReportUtil.TAG.STARTMIX, "context", "context is null");
                return false;
            }
            if (!audioDecoder.init(path, context)) {
                ReportUtil.appError(ReportUtil.TAG.STARTMIX, "init", "audioDecoder init failed");
                return false;
            }
            this.mAudioTrack = AudioUtil.createAudioTrack(audioDecoder.getMediaFormat(), 0);
            if (this.mAudioTrack == null) {
                ReportUtil.appError(ReportUtil.TAG.STARTMIX, "init", "failed to create audio track");
                return false;
            }
            if (this.processHandler == null) {
                this.startMixingProcessHandler();
            }
            float volume = (float)this.playbackVolume / 100.0f * (AudioTrack.getMaxVolume() - AudioTrack.getMinVolume());
            this.mAudioTrack.setStereoVolume(volume, volume);
            this.currentPosition = 0.0f;
            this.totalDurationUs = audioDecoder.getDurationUs();
            this.mAudioBufferStream = new AudioBufferStream(audioDecoder.getSampleRate(), audioDecoder.getChannelCount(), audioDecoder.getAudioFormat(), RTCEngineImpl.getInstance().getAudioSampleRate(), RTCEngineImpl.getInstance().isStereo() ? 2 : 1, 2);
            audioDecoder.setPcmAvailableListener(this);
            audioDecoder.setRepeatCount(loopCount);
            audioDecoder.start();
            this.mAudioDecoder = audioDecoder;
            if (defaultAudioStream != null) {
                defaultAudioStream.registerAudioBufferListener(this);
            }
            this.mState = 0;
            RCRTCAudioMixingStateChangeListener listener = this.audioMixingStateChangeListener;
            ReportUtil.libStatus(ReportUtil.TAG.MIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.PLAY, RCRTCAudioMixer.MixingStateReason.STARTED_BY_USER});
            if (listener != null) {
                listener.onStateChanged(RCRTCAudioMixer.MixingState.PLAY);
                listener.onStateChanged(RCRTCAudioMixer.MixingState.PLAY, RCRTCAudioMixer.MixingStateReason.STARTED_BY_USER);
            }
            ReportUtil.appRes(ReportUtil.TAG.STARTMIX, "path", path);
            if (this.mAudioHandler == null) {
                this.mAudioHandler = new RCAudioChannelHandler();
            }
            if (this.mAudioHandler != null && !this.mAudioHandler.isNativeAudioTrackInit()) {
                this.mAudioHandler.createAudioTrackHandler();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startWrite() {
        Object object = this.operationBlock;
        synchronized (object) {
            if (null == this.mDefaultAudioStream) {
                return false;
            }
            if (null == this.audioWriteHelper) {
                this.audioWriteHelper = new AudioWriteHelper();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start() {
        Object object = this.operationBlock;
        synchronized (object) {
            if (null == this.mDefaultAudioStream) {
                return false;
            }
            if (null == this.audioWriteHelper) {
                this.audioWriteHelper = new AudioWriteHelper();
            }
        }
        return true;
    }

    private void startMixingProcessHandler() {
        HandlerThread mThread = new HandlerThread("AudioMixerProcess");
        mThread.start();
        this.processHandler = new Handler(mThread.getLooper());
        this.processHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Handler mHandler;
                RCRTCAudioMixingStateChangeListener listener = AudioMixer.this.audioMixingStateChangeListener;
                if (listener != null) {
                    listener.onReportPlayingProgress(AudioMixer.this.getCurrentPosition());
                }
                if ((mHandler = AudioMixer.this.processHandler) != null) {
                    mHandler.postDelayed((Runnable)this, (long)AudioMixer.this.processInterval);
                }
            }
        }, (long)this.processInterval);
    }

    @Override
    public void write(byte[] data, int sampleRate, int channelCount, int audioFormat, int volume, RCRTCAudioMixer.Mode mode) {
        if (null != this.audioWriteHelper && null != this.mDefaultAudioStream) {
            this.audioWriteHelper.write(data, sampleRate, channelCount, audioFormat, volume, mode);
        } else {
            ReportUtil.libError(ReportUtil.TAG.MIXWRITE, "reason", "audioWriteHelper or mDefaultAudioStream is null ,please call start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAudioMixingStateChangeListener(RCRTCAudioMixingStateChangeListener listener) {
        Object object = this.operationBlock;
        synchronized (object) {
            this.audioMixingStateChangeListener = listener;
        }
    }

    @Override
    public void onAudioBuffer(ByteBuffer byteBuffer, int sizeInBytes, int sampleRate, int channelCount, int audioFormat) {
        if (this.mState != 0) {
            return;
        }
        AudioBufferStream audioBufferStream = this.mAudioBufferStream;
        if (audioBufferStream == null) {
            return;
        }
        byte[] data = audioBufferStream.read(sizeInBytes / (channelCount * 2));
        if (data == null) {
            return;
        }
        if (this.mKtvMode != AudioDualMonoMode.AUDIO_DUAL_MONO_STEREO && this.mAudioHandler != null && this.mAudioHandler.isNativeAudioTrackInit()) {
            if (channelCount == 2) {
                data = this.mAudioHandler.handleKtvTrackMode(data, AudioDualMonoMode.getValue(this.mKtvMode));
            } else if (channelCount == 1) {
                String msg = "- onAudioBuffer channelCnt=1 ktv scene not support, please switch audio STEREO !";
                RLog.w((String)TAG, (String)msg);
            }
        }
        AudioUtil.adjustVolumeAsShort(data, AudioUtil.linearToLog(this.mixingVolume));
        switch (this.mode) {
            case MIX: {
                AudioUtil.mixAsShort(data, byteBuffer);
                break;
            }
            case REPLACE: {
                byteBuffer.clear();
                byteBuffer.put(data);
                break;
            }
        }
    }

    @Override
    public void onPcm(byte[] data, long presentationTimeUs) {
        if (this.mState == 2) {
            return;
        }
        try {
            this.currentPosition = (float)((double)presentationTimeUs / (double)this.totalDurationUs);
        }
        catch (ArithmeticException e) {
            this.currentPosition = 0.0f;
        }
        AudioBufferStream audioBufferStream = this.mAudioBufferStream;
        if (audioBufferStream != null) {
            audioBufferStream.write(data);
        }
        AudioTrack audioTrack = this.mAudioTrack;
        if (this.playback && audioTrack != null) {
            try {
                if (this.mKtvMode != AudioDualMonoMode.AUDIO_DUAL_MONO_STEREO && this.mAudioHandler != null && this.mAudioHandler.isNativeAudioTrackInit()) {
                    data = this.mAudioHandler.handlePlayTrackMode(data, AudioDualMonoMode.getValue(this.mKtvMode));
                }
                if (Build.VERSION.SDK_INT >= 21) {
                    audioTrack.write(ByteBuffer.wrap(data), data.length, 0);
                } else {
                    audioTrack.write(data, 0, data.length);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onPcmEnd() {
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOneLoopEnd() {
        Object object = this.operationBlock;
        synchronized (object) {
            RCRTCAudioMixingStateChangeListener listener = this.audioMixingStateChangeListener;
            ReportUtil.libStatus(ReportUtil.TAG.MIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.STOPPED, RCRTCAudioMixer.MixingStateReason.ONE_LOOP_COMPLETED});
            ReportUtil.libStatus(ReportUtil.TAG.MIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.PLAY, RCRTCAudioMixer.MixingStateReason.START_NEW_LOOP});
            if (listener != null) {
                listener.onReportPlayingProgress(1.0f);
                listener.onStateChanged(RCRTCAudioMixer.MixingState.STOPPED, RCRTCAudioMixer.MixingStateReason.ONE_LOOP_COMPLETED);
                listener.onStateChanged(RCRTCAudioMixer.MixingState.PLAY, RCRTCAudioMixer.MixingStateReason.START_NEW_LOOP);
            }
        }
    }

    @Override
    public void setPlayback(boolean playback) {
        this.playback = playback;
    }

    @Override
    public void setMixingVolume(int vol) {
        this.mixingVolume = Math.max(Math.min(vol, 100), 0);
        ReportUtil.appStatus(ReportUtil.TAG.SETMIXINGVOLUME, "volume|actual", vol, this.mixingVolume);
    }

    @Override
    public int getMixingVolume() {
        return this.mixingVolume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPlaybackVolume(int vol) {
        Object object = this.operationBlock;
        synchronized (object) {
            this.playbackVolume = Math.max(Math.min(vol, 100), 0);
            ReportUtil.appStatus(ReportUtil.TAG.SETPLAYBACKVOLUME, "volume|actual", vol, this.playbackVolume);
            AudioTrack audioTrack = this.mAudioTrack;
            if (audioTrack != null) {
                float volume = (float)this.playbackVolume / 100.0f * (AudioTrack.getMaxVolume() - AudioTrack.getMinVolume());
                audioTrack.setStereoVolume(volume, volume);
            }
        }
    }

    @Override
    public int getPlaybackVolume() {
        return this.playbackVolume;
    }

    @Override
    public int getDurationMillis() {
        return (int)(this.totalDurationUs / 1000L);
    }

    @Override
    public int getDurationMillis(String path) {
        return AudioUtil.durationOfMediaFile(path);
    }

    @Override
    public float getCurrentPosition() {
        return this.currentPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seekTo(float position) {
        Object object = this.operationBlock;
        synchronized (object) {
            ReportUtil.appTask(ReportUtil.TAG.SEEKTO, "position", Float.valueOf(position));
            long presentationTimeUs = (long)((float)this.totalDurationUs * position);
            if (this.mAudioDecoder != null) {
                this.mAudioDecoder.seekTo(presentationTimeUs);
                this.currentPosition = position;
                ReportUtil.appRes(ReportUtil.TAG.SEEKTO, "position", Float.valueOf(position));
            } else {
                ReportUtil.appError(ReportUtil.TAG.SEEKTO, "error", "audio decoder is null");
            }
            if (this.mAudioTrack != null) {
                this.mAudioTrack.pause();
                this.mAudioTrack.flush();
                this.mAudioTrack.play();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopWrite() {
        Object object = this.operationBlock;
        synchronized (object) {
            if (this.audioWriteHelper != null) {
                this.audioWriteHelper.release();
                this.audioWriteHelper = null;
            }
        }
    }

    @Override
    public void stop() {
        ReportUtil.appStatus(ReportUtil.TAG.STOPMIX, "", "");
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(boolean mixEnd) {
        Object object = this.operationBlock;
        synchronized (object) {
            if (this.mState != 2) {
                ReportUtil.libStatus(ReportUtil.TAG.STOPMIX, "mixEnd", mixEnd);
                if (this.mAudioHandler != null) {
                    this.mAudioHandler.destroyAudioTrackHandler();
                }
                this.mState = 2;
                if (this.mDefaultAudioStream != null) {
                    this.mDefaultAudioStream.unregisterAudioBufferListener(this);
                }
                if (this.mAudioDecoder != null) {
                    this.mAudioDecoder.stop();
                }
                if (this.mAudioBufferStream != null) {
                    this.mAudioBufferStream.release();
                }
                if (this.mAudioTrack != null) {
                    this.mAudioTrack.pause();
                    this.mAudioTrack.release();
                }
                this.mAudioDecoder = null;
                this.mAudioBufferStream = null;
                this.mAudioTrack = null;
                this.totalDurationUs = 0L;
                this.currentPosition = 0.0f;
                if (this.processHandler != null) {
                    this.processHandler.getLooper().quit();
                    this.processHandler = null;
                }
                RCRTCAudioMixingStateChangeListener listener = this.audioMixingStateChangeListener;
                if (!mixEnd) {
                    ReportUtil.libStatus(ReportUtil.TAG.MIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.STOPPED, RCRTCAudioMixer.MixingStateReason.STOPPED_BY_USER});
                    if (listener != null) {
                        listener.onStateChanged(RCRTCAudioMixer.MixingState.STOPPED);
                        listener.onStateChanged(RCRTCAudioMixer.MixingState.STOPPED, RCRTCAudioMixer.MixingStateReason.STOPPED_BY_USER);
                    }
                } else {
                    ReportUtil.libStatus(ReportUtil.TAG.MIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.STOPPED, RCRTCAudioMixer.MixingStateReason.ALL_LOOPS_COMPLETED});
                    if (listener != null) {
                        listener.onMixEnd();
                        listener.onReportPlayingProgress(1.0f);
                        listener.onStateChanged(RCRTCAudioMixer.MixingState.STOPPED, RCRTCAudioMixer.MixingStateReason.ALL_LOOPS_COMPLETED);
                    }
                }
            } else {
                ReportUtil.libError(ReportUtil.TAG.STOPMIX, "errorState", this.mState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.operationBlock;
        synchronized (object) {
            ReportUtil.appTask(ReportUtil.TAG.RESUMEMIX, "", "");
            if (this.mState == 1) {
                ReportUtil.appRes(ReportUtil.TAG.RESUMEMIX, "", "");
                this.mState = 0;
                RCRTCAudioMixingStateChangeListener listener = this.audioMixingStateChangeListener;
                ReportUtil.libStatus(ReportUtil.TAG.MIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.PLAY, RCRTCAudioMixer.MixingStateReason.RESUMED_BY_USER});
                if (listener != null) {
                    listener.onStateChanged(RCRTCAudioMixer.MixingState.PLAY);
                    listener.onStateChanged(RCRTCAudioMixer.MixingState.PLAY, RCRTCAudioMixer.MixingStateReason.RESUMED_BY_USER);
                }
            } else {
                ReportUtil.appError(ReportUtil.TAG.RESUMEMIX, "errorState", this.mState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.operationBlock;
        synchronized (object) {
            ReportUtil.appTask(ReportUtil.TAG.PAUSEMIX, "", "");
            if (this.mState == 0) {
                ReportUtil.appRes(ReportUtil.TAG.PAUSEMIX, "", "");
                this.mState = 1;
                RCRTCAudioMixingStateChangeListener listener = this.audioMixingStateChangeListener;
                ReportUtil.libStatus(ReportUtil.TAG.MIXINGSTATECHANGED, "to|reason", new Object[]{RCRTCAudioMixer.MixingState.PAUSED, RCRTCAudioMixer.MixingStateReason.PAUSED_BY_USER});
                if (listener != null) {
                    listener.onStateChanged(RCRTCAudioMixer.MixingState.PAUSED);
                    listener.onStateChanged(RCRTCAudioMixer.MixingState.PAUSED, RCRTCAudioMixer.MixingStateReason.PAUSED_BY_USER);
                }
            } else {
                ReportUtil.appError(ReportUtil.TAG.PAUSEMIX, "errorState", this.mState);
            }
        }
    }

    @Override
    public void setVolume(int volume) {
        this.setPlaybackVolume(volume);
        this.setMixingVolume(volume);
    }

    @Override
    public void setAudioDualMonoMode(AudioDualMonoMode mode) {
        RLog.d((String)TAG, (String)("- setAudioDualMonoMode:" + (Object)((Object)mode)));
        ReportUtil.appStatus(ReportUtil.TAG.SETAUDIODUALMONOMODE, "status|mode", new Object[]{"- setAudioDualMonoMode", mode});
        this.mKtvMode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMixingProcessInterval(int processInterval) {
        Object object = this.operationBlock;
        synchronized (object) {
            if (processInterval > 2000 || processInterval < 200) {
                return;
            }
            this.processInterval = processInterval;
            if (this.processHandler != null) {
                this.processHandler.getLooper().quit();
                this.startMixingProcessHandler();
            }
        }
    }
}

