/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import android.app.Notification;
import android.content.Intent;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import com.liulishuo.filedownloader.i.IFileDownloadIPCCallback;
import com.liulishuo.filedownloader.i.IFileDownloadIPCService;
import com.liulishuo.filedownloader.message.MessageSnapshot;
import com.liulishuo.filedownloader.message.MessageSnapshotFlow;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.services.FileDownloadManager;
import com.liulishuo.filedownloader.services.FileDownloadService;
import com.liulishuo.filedownloader.services.IFileDownloadServiceHandler;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import java.lang.ref.WeakReference;

public class FDServiceSeparateHandler
extends IFileDownloadIPCService.Stub
implements MessageSnapshotFlow.MessageReceiver,
IFileDownloadServiceHandler {
    private final RemoteCallbackList<IFileDownloadIPCCallback> callbackList = new RemoteCallbackList();
    private final FileDownloadManager downloadManager;
    private final WeakReference<FileDownloadService> wService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int callback(MessageSnapshot snapShot) {
        int n = this.callbackList.beginBroadcast();
        try {
            for (int i = 0; i < n; ++i) {
                ((IFileDownloadIPCCallback)this.callbackList.getBroadcastItem(i)).callback(snapShot);
            }
        }
        catch (RemoteException e) {
            FileDownloadLog.e((Object)this, e, "callback error", new Object[0]);
        }
        finally {
            this.callbackList.finishBroadcast();
        }
        return n;
    }

    FDServiceSeparateHandler(WeakReference<FileDownloadService> wService, FileDownloadManager manager) {
        this.wService = wService;
        this.downloadManager = manager;
        MessageSnapshotFlow.getImpl().setReceiver(this);
    }

    @Override
    public void registerCallback(IFileDownloadIPCCallback callback) throws RemoteException {
        this.callbackList.register((IInterface)callback);
    }

    @Override
    public void unregisterCallback(IFileDownloadIPCCallback callback) throws RemoteException {
        this.callbackList.unregister((IInterface)callback);
    }

    @Override
    public boolean checkDownloading(String url, String path) throws RemoteException {
        return this.downloadManager.isDownloading(url, path);
    }

    @Override
    public void start(String url, String path, boolean pathAsDirectory, int callbackProgressTimes, int callbackProgressMinIntervalMillis, int autoRetryTimes, boolean forceReDownload, FileDownloadHeader header, boolean isWifiRequired) throws RemoteException {
        this.downloadManager.start(url, path, pathAsDirectory, callbackProgressTimes, callbackProgressMinIntervalMillis, autoRetryTimes, forceReDownload, header, isWifiRequired);
    }

    @Override
    public boolean pause(int downloadId) throws RemoteException {
        return this.downloadManager.pause(downloadId);
    }

    @Override
    public void pauseAllTasks() throws RemoteException {
        this.downloadManager.pauseAll();
    }

    @Override
    public boolean setMaxNetworkThreadCount(int count) throws RemoteException {
        return this.downloadManager.setMaxNetworkThreadCount(count);
    }

    @Override
    public long getSofar(int downloadId) throws RemoteException {
        return this.downloadManager.getSoFar(downloadId);
    }

    @Override
    public long getTotal(int downloadId) throws RemoteException {
        return this.downloadManager.getTotal(downloadId);
    }

    @Override
    public byte getStatus(int downloadId) throws RemoteException {
        return this.downloadManager.getStatus(downloadId);
    }

    @Override
    public boolean isIdle() throws RemoteException {
        return this.downloadManager.isIdle();
    }

    @Override
    public void startForeground(int id, Notification notification) throws RemoteException {
        if (this.wService != null && this.wService.get() != null) {
            ((FileDownloadService)((Object)this.wService.get())).startForeground(id, notification);
        }
    }

    @Override
    public void stopForeground(boolean removeNotification) throws RemoteException {
        if (this.wService != null && this.wService.get() != null) {
            ((FileDownloadService)((Object)this.wService.get())).stopForeground(removeNotification);
        }
    }

    @Override
    public boolean clearTaskData(int id) throws RemoteException {
        return this.downloadManager.clearTaskData(id);
    }

    @Override
    public void clearAllTaskData() throws RemoteException {
        this.downloadManager.clearAllTaskData();
    }

    @Override
    public void onStartCommand(Intent intent, int flags, int startId) {
    }

    @Override
    public IBinder onBind(Intent intent) {
        return this;
    }

    @Override
    public void onDestroy() {
        MessageSnapshotFlow.getImpl().setReceiver(null);
    }

    @Override
    public void receive(MessageSnapshot snapShot) {
        this.callback(snapShot);
    }
}

