/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.util;

import android.annotation.SuppressLint;
import android.content.Context;
import com.liulishuo.filedownloader.IThreadPoolMonitor;
import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.exception.PathConflictException;
import com.liulishuo.filedownloader.message.MessageSnapshotFlow;
import com.liulishuo.filedownloader.message.MessageSnapshotTaker;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.stream.FileDownloadOutputStream;
import java.io.File;
import java.io.IOException;

public class FileDownloadHelper {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context APP_CONTEXT;

    public static void holdContext(Context context) {
        APP_CONTEXT = context;
    }

    public static Context getAppContext() {
        return APP_CONTEXT;
    }

    public static boolean inspectAndInflowDownloaded(int id, String path, boolean forceReDownload, boolean flowDirectly) {
        File file;
        if (forceReDownload) {
            return false;
        }
        if (path != null && (file = new File(path)).exists()) {
            MessageSnapshotFlow.getImpl().inflow(MessageSnapshotTaker.catchCanReusedOldFile(id, file, flowDirectly));
            return true;
        }
        return false;
    }

    public static boolean inspectAndInflowDownloading(int id, FileDownloadModel model, IThreadPoolMonitor monitor, boolean flowDirectly) {
        if (monitor.isDownloading(model)) {
            MessageSnapshotFlow.getImpl().inflow(MessageSnapshotTaker.catchWarn(id, model.getSoFar(), model.getTotal(), flowDirectly));
            return true;
        }
        return false;
    }

    public static boolean inspectAndInflowConflictPath(int id, long sofar, String tempFilePath, String targetFilePath, IThreadPoolMonitor monitor) {
        int anotherSameTempPathTaskId;
        if (targetFilePath != null && tempFilePath != null && (anotherSameTempPathTaskId = monitor.findRunningTaskIdBySameTempPath(tempFilePath, id)) != 0) {
            MessageSnapshotFlow.getImpl().inflow(MessageSnapshotTaker.catchException(id, sofar, new PathConflictException(anotherSameTempPathTaskId, tempFilePath, targetFilePath)));
            return true;
        }
        return false;
    }

    public static interface ConnectionCreator {
        public FileDownloadConnection create(String var1) throws IOException;
    }

    public static interface OutputStreamCreator {
        public FileDownloadOutputStream create(File var1) throws IOException;

        public boolean supportSeek();
    }

    public static interface DatabaseCustomMaker {
        public FileDownloadDatabase customMake();
    }

    public static interface ConnectionCountAdapter {
        public int determineConnectionCount(int var1, String var2, String var3, long var4);
    }

    public static interface IdGenerator {
        public int transOldId(int var1, String var2, String var3, boolean var4);

        public int generateId(String var1, String var2, boolean var3);
    }
}

