/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.plugin;

import cn.rongcloud.rtc.plugin.FaceBeautifierPlugin;
import cn.rongcloud.rtc.plugin.VoiceBeautifierPlugin;
import cn.rongcloud.rtc.plugin.player.IPlayer;
import cn.rongcloud.rtc.plugin.player.IPlayerBase;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PluginUtils {
    private static final String TAG = "PluginUtils";

    public static FaceBeautifierPlugin loadFaceBeautyPlugin() {
        FaceBeautifierPlugin faceBeautifierPlugin = null;
        String loadResult = "success";
        try {
            Class<?> clz = Class.forName("cn.rongcloud.beauty.RCRTCBeautyEngineImpl");
            Method method = clz.getMethod("create", new Class[0]);
            faceBeautifierPlugin = (FaceBeautifierPlugin)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            loadResult = e.getMessage();
        }
        ReportUtil.libStatus(ReportUtil.TAG.FACE_BEAUTY_LOAD, "result", loadResult);
        return faceBeautifierPlugin;
    }

    public static VoiceBeautifierPlugin loadVoiceBeautyPlugin() {
        VoiceBeautifierPlugin plugin = null;
        String loadResult = "success";
        try {
            Class<?> clz = Class.forName("cn.rongcloud.voicebeautifier.RCRTCVoiceBeautifierEngineImp");
            Method method = clz.getMethod("create", new Class[0]);
            method.setAccessible(true);
            plugin = (VoiceBeautifierPlugin)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            loadResult = e.getMessage();
        }
        ReportUtil.libStatus(ReportUtil.TAG.VOICE_BEAUTIFIER_LOAD, "result", loadResult);
        return plugin;
    }

    public static boolean hasPlayerPlugin() {
        Object player = null;
        boolean ret = false;
        try {
            Constructor<?> constructor = Class.forName("cn.rongcloud.rtc.media.player.api.RCPlayerEngine").getConstructor(new Class[0]);
            if (null != constructor) {
                ret = true;
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            ret = false;
        }
        return ret;
    }

    public static IPlayer loadPlayerPlugin() {
        IPlayer player = null;
        String msg = "";
        try {
            Constructor<?> constructor = Class.forName("cn.rongcloud.rtc.media.player.api.RCPlayerEngine").getConstructor(new Class[0]);
            player = (IPlayer)constructor.newInstance(new Object[0]);
            msg = "success";
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            msg = String.valueOf(e);
        }
        ReportUtil.libStatus(ReportUtil.TAG.PLAYER_STATE, "desc", "IPlayer init : " + msg);
        return player;
    }

    public static IPlayerBase loadPlayerPluginByName(String className) {
        IPlayerBase player = null;
        String msg = "";
        try {
            Class<?> c = Class.forName(className);
            Constructor<?> constructor = c.getConstructor(new Class[0]);
            player = (IPlayerBase)constructor.newInstance(new Object[0]);
            msg = "success";
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            msg = "NoSuchMethodException";
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            msg = "ClassNotFoundException";
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            msg = "IllegalAccessException";
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            msg = "InstantiationException";
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            msg = "InvocationTargetException";
        }
        ReportUtil.libStatus(ReportUtil.TAG.PLAYER_STATE, "desc", "className init : " + msg);
        return player;
    }
}

